
{REDUND_ERROR} FUNCTION_BLOCK PMC_6DMotion (*Move single xbot in 6 degrees of freedom (fixed velocity)*) (*$GROUP=User,$CAT=User,$GROUPICON=User.png,$CATICON=User.png*)
	VAR_INPUT
		Execute : {REDUND_UNREPLICABLE} BOOL; (* Execution of the function block begins on a rising edge of this input.*)
		cmdLB : {REDUND_UNREPLICABLE} UINT; (* label to be associated with this command in the PMC*)
		XbotID : {REDUND_UNREPLICABLE} USINT; (* ID# of the xbot to move (>0)*)
		PosX : {REDUND_UNREPLICABLE} REAL; (* X position in meters*)
		PosY : {REDUND_UNREPLICABLE} REAL; (* Y position in meters	*)
		PosZ : {REDUND_UNREPLICABLE} REAL; (* Z position in meters*)
		PosRx : {REDUND_UNREPLICABLE} REAL; (* rotation about the X axis in radians*)
		PosRy : {REDUND_UNREPLICABLE} REAL; (* rotation about the Y axis in radians*)
		PosRz : {REDUND_UNREPLICABLE} REAL; (* rotation about the Z axis in radians*)
	END_VAR
	VAR_OUTPUT
		Ack : {REDUND_UNREPLICABLE} BOOL := FALSE; (* Command has been received by PMC, any returned values can be used*)
		Done : {REDUND_UNREPLICABLE} BOOL; (* Xbot's motion has completed*)
		Busy : {REDUND_UNREPLICABLE} BOOL := FALSE; (* Function block is active and must continue to be called.*)
		Aborted : {REDUND_UNREPLICABLE} BOOL := FALSE; (* Command aborted by another command*)
		Error : {REDUND_UNREPLICABLE} BOOL := FALSE; (* Error occurred during execution.*)
		ErrorID : {REDUND_UNREPLICABLE} UINT := 0; (* Error number*)
		TravelTime : {REDUND_UNREPLICABLE} REAL; (* Time needed for the motion to complete in seconds *)
	END_VAR
	VAR_IN_OUT
		PM_Controller : PMControllerType; (*Tracks state of the entire PMC system*)
	END_VAR
	VAR
		PMCFuncInfo : {REDUND_UNREPLICABLE} PMCFuncInfoType;
		timeout : {REDUND_UNREPLICABLE} UINT;
		cmdHB : {REDUND_UNREPLICABLE} INT;
		nTemp : {REDUND_UNREPLICABLE} DWORD;
		requestEventID : BOOL;
	END_VAR
	VAR CONSTANT
		cmdID : UINT := 2832;
	END_VAR
END_FUNCTION_BLOCK

{REDUND_ERROR} FUNCTION_BLOCK PMC_6DMotionVelocity (*Move single xbot in 6 degrees of freedom (user set velocity*) (*$GROUP=User,$CAT=User,$GROUPICON=User.png,$CATICON=User.png*)
	VAR_INPUT
		Execute : {REDUND_UNREPLICABLE} BOOL; (* Execution of the function block begins on a rising edge of this input.*)
		cmdLB : {REDUND_UNREPLICABLE} UINT; (* label to be associated with this command in the PMC*)
		XbotID : {REDUND_UNREPLICABLE} USINT; (* ID# of the xbot to move (>0)*)
		TargetPos : {REDUND_UNREPLICABLE} ARRAY[0..5] OF REAL; (* [x,y,z,rx,ry,rz] in meters for position, in radians for rotation*)
		LongAxisAccVel : {REDUND_UNREPLICABLE} ARRAY[0..1] OF REAL; (* [long axis accel,long axis vel] meters/second^2, meters/second*)
		ShortAxisVel : {REDUND_UNREPLICABLE} ARRAY[0..3] OF REAL; (* [z vel,rx vel,ry vel,rz vel] meters/second for Z position, radians for rotations*)
	END_VAR
	VAR_OUTPUT
		Ack : {REDUND_UNREPLICABLE} BOOL; (* Command has been received by PMC, any returned values can be used*)
		Done : {REDUND_UNREPLICABLE} BOOL; (* Xbot's motion has completed*)
		Busy : {REDUND_UNREPLICABLE} BOOL; (* Function block is active and must continue to be called.*)
		Aborted : {REDUND_UNREPLICABLE} BOOL; (* Command aborted by another command*)
		Error : {REDUND_UNREPLICABLE} BOOL; (* Error occurred during execution.*)
		ErrorID : {REDUND_UNREPLICABLE} UINT; (* Error number*)
		TravelTime : {REDUND_UNREPLICABLE} REAL; (* Time needed for the motion to complete in seconds *)
	END_VAR
	VAR_IN_OUT
		PM_Controller : PMControllerType; (*Tracks state of the entire PMC system*)
	END_VAR
	VAR
		PMCFuncInfo : {REDUND_UNREPLICABLE} PMCFuncInfoType;
		timeout : {REDUND_UNREPLICABLE} UINT;
		cmdHB : {REDUND_UNREPLICABLE} INT;
		nTemp : {REDUND_UNREPLICABLE} DWORD;
		requestEventID : BOOL;
	END_VAR
	VAR CONSTANT
		cmdID : UINT := 2851;
	END_VAR
END_FUNCTION_BLOCK

{REDUND_ERROR} FUNCTION_BLOCK PMC_ActivateTrajectory (*Command 1 - 12 xbots to follow trajectories*) (*$GROUP=User,$CAT=User,$GROUPICON=User.png,$CATICON=User.png*)
	VAR_INPUT
		Execute : {REDUND_UNREPLICABLE} BOOL; (* Execution of the function block begins on a rising edge of this input.*)
		cmdLB : {REDUND_UNREPLICABLE} UINT; (* label to be associated with this command in the PMC*)
		nXbots : {REDUND_UNREPLICABLE} USINT; (* number of xbots commanded to follow trajectories (up to 12)*)
		XbotID : {REDUND_UNREPLICABLE} ARRAY[0..11] OF USINT; (* ID#s of xbots to follow trajectories*)
		TrajID : {REDUND_UNREPLICABLE} ARRAY[0..11] OF USINT; (* ID#s of the trajectories that the xbots are to follow*)
	END_VAR
	VAR_OUTPUT
		Ack : {REDUND_UNREPLICABLE} BOOL; (* Command has been received by PMC, any returned values can be used*)
		Done : {REDUND_UNREPLICABLE} BOOL; (* Xbot(s) have finished their trajectory(ies)*)
		Busy : {REDUND_UNREPLICABLE} BOOL; (* Function block is active and must continue to be called.*)
		Aborted : {REDUND_UNREPLICABLE} BOOL; (* Command aborted by another command*)
		Error : {REDUND_UNREPLICABLE} BOOL; (* Error occurred during execution.*)
		ErrorID : {REDUND_UNREPLICABLE} UINT; (* Error number*)
		TravelTime : {REDUND_UNREPLICABLE} REAL; (* Time needed for the motion to complete in seconds *)
	END_VAR
	VAR_IN_OUT
		PM_Controller : PMControllerType; (*Tracks state of the entire PMC system*)
	END_VAR
	VAR
		PMCFuncInfo : {REDUND_UNREPLICABLE} PMCFuncInfoType;
		timeout : {REDUND_UNREPLICABLE} UINT;
		cmdHB : {REDUND_UNREPLICABLE} INT;
		nTemp : {REDUND_UNREPLICABLE} DWORD;
		xbotNum : {REDUND_UNREPLICABLE} USINT;
		xIndex : {REDUND_UNREPLICABLE} SINT;
		requestEventID : BOOL;
	END_VAR
	VAR CONSTANT
		cmdID : UINT := 2823;
		maxNXbots : SINT := 12;
	END_VAR
END_FUNCTION_BLOCK

{REDUND_ERROR} FUNCTION_BLOCK PMC_ActivateXbots (*Activate all xbots*) (*$GROUP=User,$CAT=User,$GROUPICON=User.png,$CATICON=User.png*)
	VAR_INPUT
		Execute : {REDUND_UNREPLICABLE} BOOL; (* Execution of the function block begins on a rising edge of this input.*)
	END_VAR
	VAR_OUTPUT
		Ack : {REDUND_UNREPLICABLE} BOOL; (* Command has been received by PMC, any returned values can be used *)
		Done : {REDUND_UNREPLICABLE} BOOL; (* Xbots have finished activating *)
		Busy : {REDUND_UNREPLICABLE} BOOL; (* Function block is active and must continue to be called.*)
		Aborted : {REDUND_UNREPLICABLE} BOOL; (* Command aborted by another command*)
		Error : {REDUND_UNREPLICABLE} BOOL; (* Error occurred during execution.*)
		ErrorID : {REDUND_UNREPLICABLE} UINT; (* Error number*)
	END_VAR
	VAR_IN_OUT
		PM_Controller : PMControllerType; (*Tracks state of the entire PMC system*)
	END_VAR
	VAR
		PMCFuncInfo : {REDUND_UNREPLICABLE} PMCFuncInfoType;
		timeout : {REDUND_UNREPLICABLE} UINT;
		cmdHB : {REDUND_UNREPLICABLE} INT;
		requestEventID : BOOL;
	END_VAR
	VAR CONSTANT
		cmdID : UINT := 2568;
	END_VAR
END_FUNCTION_BLOCK

{REDUND_ERROR} FUNCTION_BLOCK PMC_ArcMotionCenter (*Command single xbot to follow a circular arc defined by arc center and arc angle*) (*$GROUP=User,$CAT=User,$GROUPICON=User.png,$CATICON=User.png*)
	VAR_INPUT
		Execute : {REDUND_UNREPLICABLE} BOOL; (* Execution of the function block begins on a rising edge of this input.*)
		cmdLB : {REDUND_UNREPLICABLE} UINT; (* label to be associated with this command in the PMC*)
		XbotID : {REDUND_UNREPLICABLE} USINT; (* ID# of the xbot to move (>0)*)
		Mode : {REDUND_UNREPLICABLE} USINT; (* 0:absolute;1: relative*)
		Dir : {REDUND_UNREPLICABLE} USINT; (* 0:clockwise;1:counter-clockwise*)
		EndVel : {REDUND_UNREPLICABLE} REAL; (* Velocity at the end of the motion in meters/second*)
		MaxVel : {REDUND_UNREPLICABLE} REAL := 1.0; (* Maximum velocity for this motion in meters/second*)
		MaxAcc : {REDUND_UNREPLICABLE} REAL := 10.0; (* Maximum acceleration for this motion in meters/second^2*)
		CenterX : {REDUND_UNREPLICABLE} REAL; (* X location of the arc center in meters *)
		CenterY : {REDUND_UNREPLICABLE} REAL; (* Y location of the arc center in meters*)
		Angle : {REDUND_UNREPLICABLE} REAL; (* Arc angle in radians *)
	END_VAR
	VAR_OUTPUT
		Ack : {REDUND_UNREPLICABLE} BOOL; (* Command has been received by PMC, any returned values can be used*)
		Done : {REDUND_UNREPLICABLE} BOOL; (* Xbot's motion has completed*)
		Busy : {REDUND_UNREPLICABLE} BOOL; (* Function block is active and must continue to be called.*)
		Aborted : {REDUND_UNREPLICABLE} BOOL; (* Command aborted by another command*)
		Error : {REDUND_UNREPLICABLE} BOOL; (* Error occurred during execution.*)
		ErrorID : {REDUND_UNREPLICABLE} UINT; (* Error number*)
		TravelTime : {REDUND_UNREPLICABLE} REAL; (* Time needed for the motion to complete in seconds*)
	END_VAR
	VAR_IN_OUT
		PM_Controller : PMControllerType; (*Tracks state of the entire PMC system*)
	END_VAR
	VAR
		PMCFuncInfo : {REDUND_UNREPLICABLE} PMCFuncInfoType;
		timeout : {REDUND_UNREPLICABLE} UINT;
		cmdHB : {REDUND_UNREPLICABLE} INT;
		nTemp : {REDUND_UNREPLICABLE} DWORD;
		requestEventID : BOOL;
	END_VAR
	VAR CONSTANT
		cmdID : UINT := 2826;
		aDef : USINT := 1;
	END_VAR
END_FUNCTION_BLOCK

{REDUND_ERROR} FUNCTION_BLOCK PMC_ArcMotionTarget (*Command single xbots to follow a circular arc defined by target position and arc radius *) (*$GROUP=User,$CAT=User,$GROUPICON=User.png,$CATICON=User.png*)
	VAR_INPUT
		Execute : {REDUND_UNREPLICABLE} BOOL; (* Execution of the function block begins on a rising edge of this input.*)
		cmdLB : {REDUND_UNREPLICABLE} UINT; (* label to be associated with this command in the PMC*)
		XbotID : {REDUND_UNREPLICABLE} USINT; (* ID# of the xbot to move (>0)*)
		Mode : {REDUND_UNREPLICABLE} USINT; (* 0:absolute;1: relative*)
		AType : {REDUND_UNREPLICABLE} USINT; (* 0: Minor Arc;1: Major Arc*)
		Dir : {REDUND_UNREPLICABLE} USINT; (* 0:clockwise;1:counter-clockwise*)
		EndVel : {REDUND_UNREPLICABLE} REAL; (* Velocity at the end of the motion in meters/second*)
		MaxVel : {REDUND_UNREPLICABLE} REAL := 1.0; (* Maximum velocity for this motion in meters/second*)
		MaxAcc : {REDUND_UNREPLICABLE} REAL := 10.0; (* Maximum acceleration for this motion in meters/second^2*)
		PosX : {REDUND_UNREPLICABLE} REAL; (* X target position in meters*)
		PosY : {REDUND_UNREPLICABLE} REAL; (* Y target position in meters*)
		Radius : {REDUND_UNREPLICABLE} REAL; (* Arc radius in meters*)
	END_VAR
	VAR_OUTPUT
		Ack : {REDUND_UNREPLICABLE} BOOL; (* Command has been received by PMC, any returned values can be used*)
		Done : {REDUND_UNREPLICABLE} BOOL; (* Xbot's motion has completed*)
		Busy : {REDUND_UNREPLICABLE} BOOL; (* Function block is active and must continue to be called.*)
		Aborted : {REDUND_UNREPLICABLE} BOOL; (* Command aborted by another command*)
		Error : {REDUND_UNREPLICABLE} BOOL; (* Error occurred during execution.*)
		ErrorID : {REDUND_UNREPLICABLE} UINT; (* Error number*)
		TravelTime : {REDUND_UNREPLICABLE} REAL; (* Time needed for the motion to complete in seconds*)
	END_VAR
	VAR_IN_OUT
		PM_Controller : PMControllerType; (*Tracks state of the entire PMC system*)
	END_VAR
	VAR
		PMCFuncInfo : {REDUND_UNREPLICABLE} PMCFuncInfoType;
		timeout : {REDUND_UNREPLICABLE} UINT;
		cmdHB : {REDUND_UNREPLICABLE} INT;
		nTemp : {REDUND_UNREPLICABLE} DWORD;
		requestEventID : BOOL;
	END_VAR
	VAR CONSTANT
		cmdID : UINT := 2826;
		aDef : USINT := 0;
	END_VAR
END_FUNCTION_BLOCK

{REDUND_ERROR} FUNCTION_BLOCK PMC_AutoDrivingMotion (* Command multiple xbots (1-78) to target positions. Pathing is determined by PMC.*)
	VAR_INPUT
		Execute : {REDUND_UNREPLICABLE} BOOL; (* Execution of the function block begins on a rising edge of this input.*)
		nXbots : {REDUND_UNREPLICABLE} USINT; (* number of xbots to move (up to 78)*)
		XbotID : {REDUND_UNREPLICABLE} ARRAY[0..77] OF USINT; (* ID#s of xbots to move*)
		PosX : {REDUND_UNREPLICABLE} ARRAY[0..77] OF REAL; (* Target X positions (m)*)
		PosY : {REDUND_UNREPLICABLE} ARRAY[0..77] OF REAL; (* Target Y positions (m)*)
	END_VAR
	VAR_OUTPUT
		Ack : {REDUND_UNREPLICABLE} BOOL; (* Command has been received by PMC, any returned values can be used*)
		Done : {REDUND_UNREPLICABLE} BOOL; (* Xbot(s) motion has completed*)
		Busy : {REDUND_UNREPLICABLE} BOOL; (* Function block is active and must continue to be called.*)
		Aborted : {REDUND_UNREPLICABLE} BOOL; (* Command aborted by another command*)
		Error : {REDUND_UNREPLICABLE} BOOL; (* Error occurred during execution.*)
		ErrorID : {REDUND_UNREPLICABLE} UINT; (* Error number*)
	END_VAR
	VAR_IN_OUT
		PM_Controller : PMControllerType; (*Tracks state of the entire PMC system*)
	END_VAR
	VAR
		PMCFuncInfo : {REDUND_UNREPLICABLE} PMCFuncInfoType;
		timeout : {REDUND_UNREPLICABLE} UINT;
		numFrames : {REDUND_UNREPLICABLE} DINT;
		cmdHB : {REDUND_UNREPLICABLE} INT;
		totalXbotNum : {REDUND_UNREPLICABLE} SINT;
		xIndex : {REDUND_UNREPLICABLE} SINT;
		beginning_index : {REDUND_UNREPLICABLE} SINT;
		numXbotsToSend : {REDUND_UNREPLICABLE} SINT;
		requestEventID : BOOL;
	END_VAR
	VAR CONSTANT
		cmdID : UINT := 2836;
		maxNXbot : SINT := 78;
		maxNXbotPerFrame : SINT := 9;
	END_VAR
END_FUNCTION_BLOCK

{REDUND_ERROR} FUNCTION_BLOCK PMC_AutoDrivingMotionVelocity (* Command multiple xbots (1-78) to target positions (user set velocity and acceleration). Pathing is determined by PMC.*)
	VAR_INPUT
		Execute : {REDUND_UNREPLICABLE} BOOL; (* Execution of the function block begins on a rising edge of this input.*)
		nXbots : {REDUND_UNREPLICABLE} USINT; (* number of xbots to move (up to 78)	*)
		XbotID : {REDUND_UNREPLICABLE} ARRAY[0..77] OF USINT; (* ID#s of xbots to move*)
		PosX : {REDUND_UNREPLICABLE} ARRAY[0..77] OF REAL; (* Target X positions (m)*)
		PosY : {REDUND_UNREPLICABLE} ARRAY[0..77] OF REAL; (* Target Y positions (m)*)
		OnlyMoveSelectedXbots : {REDUND_UNREPLICABLE} USINT; (* 0: all xbots can be moved to implement the command, 1: only the selected bots are moveable during the command*)
		MaxVel : {REDUND_UNREPLICABLE} REAL; (* Maximum velocity of the xbots during the command (m/s)*)
		MaxAcc : {REDUND_UNREPLICABLE} REAL; (* Maximum acceleration of the xbots during the command (m/s^2)*)
	END_VAR
	VAR_OUTPUT
		Ack : {REDUND_UNREPLICABLE} BOOL; (* Command has been received by PMC, any returned values can be used*)
		Done : {REDUND_UNREPLICABLE} BOOL; (* Xbot(s) motion has completed*)
		Busy : {REDUND_UNREPLICABLE} BOOL; (* Function block is active and must continue to be called.*)
		Aborted : {REDUND_UNREPLICABLE} BOOL; (* Command aborted by another command*)
		Error : {REDUND_UNREPLICABLE} BOOL; (* Error occurred during execution.*)
		ErrorID : {REDUND_UNREPLICABLE} UINT; (* Error number*)
	END_VAR
	VAR_IN_OUT
		PM_Controller : PMControllerType; (*Tracks state of the entire PMC system*)
	END_VAR
	VAR
		PMCFuncInfo : {REDUND_UNREPLICABLE} PMCFuncInfoType;
		timeout : {REDUND_UNREPLICABLE} UINT;
		numFrames : {REDUND_UNREPLICABLE} DINT;
		cmdHB : {REDUND_UNREPLICABLE} INT;
		xIndex : {REDUND_UNREPLICABLE} SINT;
		totalXbotNum : {REDUND_UNREPLICABLE} SINT;
		beginning_index : {REDUND_UNREPLICABLE} SINT;
		numXbotsToSend : {REDUND_UNREPLICABLE} SINT;
		requestEventID : BOOL;
	END_VAR
	VAR CONSTANT
		cmdID : UINT := 2856;
		maxNXbot : SINT := 78;
		maxNXbotPerFrame : SINT := 9;
	END_VAR
END_FUNCTION_BLOCK

{REDUND_ERROR} {REDUND_UNREPLICABLE} FUNCTION_BLOCK PMC_AutoLoadingZone_Activate (*activates an autoloading zone*) (*$GROUP=User,$CAT=User,$GROUPICON=User.png,$CATICON=User.png*)
	VAR_INPUT
		Execute : {REDUND_UNREPLICABLE} BOOL; (* Execution of the function block begins on a rising edge of this input.	*)
		ZoneID : {REDUND_UNREPLICABLE} USINT; (* zone ID: >0 for creation/activation/deactivation; >=0 with delete zone(s)*)
	END_VAR
	VAR_OUTPUT
		Done : {REDUND_UNREPLICABLE} BOOL; (* Execution successful. Function block is finished*)
		Busy : {REDUND_UNREPLICABLE} BOOL; (* Function block is active and must continue to be called.*)
		Aborted : {REDUND_UNREPLICABLE} BOOL; (* Command aborted by another command*)
		Error : {REDUND_UNREPLICABLE} BOOL; (* Error occurred during execution.*)
		ErrorID : {REDUND_UNREPLICABLE} UINT; (* Error number*)
	END_VAR
	VAR_IN_OUT
		PM_Controller : PMControllerType; (*Tracks state of the entire PMC system*)
	END_VAR
	VAR
		PMCFuncInfo : {REDUND_UNREPLICABLE} PMCFuncInfoType;
		timeout : {REDUND_UNREPLICABLE} UINT;
		cmdHB : {REDUND_UNREPLICABLE} INT;
		nTemp : {REDUND_UNREPLICABLE} DWORD;
		DummyDone : {REDUND_UNREPLICABLE} BOOL;
	END_VAR
	VAR CONSTANT
		Mode : USINT := 2; (* 2: activate zone*)
		cmdID : UINT := 3078;
	END_VAR
END_FUNCTION_BLOCK

{REDUND_ERROR} {REDUND_UNREPLICABLE} FUNCTION_BLOCK PMC_AutoLoadingZone_Create (*Creates a new autoloading zone*) (*$GROUP=User,$CAT=User,$GROUPICON=User.png,$CATICON=User.png*)
	VAR_INPUT
		Execute : {REDUND_UNREPLICABLE} BOOL; (* Execution of the function block begins on a rising edge of this input.	*)
		ZoneID : {REDUND_UNREPLICABLE} USINT; (* zone ID: >0 for creation*)
		ZoneMode : {REDUND_UNREPLICABLE} USINT; (* 0: unloading zone, 1: loading zone*)
		UnloadingMode : {REDUND_UNREPLICABLE} USINT; (* 0: soft-landing mode, 1: hard-landing mode*)
		ZoneCenterX : {REDUND_UNREPLICABLE} REAL; (* X coordinate of zone center at flyway boundary (m)*)
		ZoneCenterY : {REDUND_UNREPLICABLE} REAL; (* Y coordinate of zone center at flyway boundary (m)*)
		ZoneLength : {REDUND_UNREPLICABLE} REAL; (* zone length in loading/unloading direction (m)*)
		ZoneWidth : {REDUND_UNREPLICABLE} REAL; (* zone width (m)*)
		MaxXbotSizeX : {REDUND_UNREPLICABLE} REAL; (* max mover size in X (m)*)
		MaxXbotSizeY : {REDUND_UNREPLICABLE} REAL; (* max mover size in Y (m)*)
		MaxVel : {REDUND_UNREPLICABLE} REAL; (* max travilling speed inside the zone (m/s)*)
		MaxAcc : {REDUND_UNREPLICABLE} REAL; (* max travelling acceleration inside the zone (m/s^s)*)
	END_VAR
	VAR_OUTPUT
		Done : {REDUND_UNREPLICABLE} BOOL; (* Execution successful. Function block is finished*)
		Busy : {REDUND_UNREPLICABLE} BOOL; (* Function block is active and must continue to be called.*)
		Aborted : {REDUND_UNREPLICABLE} BOOL; (* Command aborted by another command*)
		Error : {REDUND_UNREPLICABLE} BOOL; (* Error occurred during execution.*)
		ErrorID : {REDUND_UNREPLICABLE} UINT; (* Error number*)
	END_VAR
	VAR_IN_OUT
		PM_Controller : PMControllerType; (*Tracks state of the entire PMC system*)
	END_VAR
	VAR
		PMCFuncInfo : {REDUND_UNREPLICABLE} PMCFuncInfoType;
		timeout : {REDUND_UNREPLICABLE} UINT;
		cmdHB : {REDUND_UNREPLICABLE} INT;
		nTemp : {REDUND_UNREPLICABLE} DWORD;
		DummyDone : {REDUND_UNREPLICABLE} BOOL;
	END_VAR
	VAR CONSTANT
		Mode : USINT := 0; (* 0: create zone*)
		cmdID : UINT := 3078;
	END_VAR
END_FUNCTION_BLOCK

{REDUND_ERROR} {REDUND_UNREPLICABLE} FUNCTION_BLOCK PMC_AutoLoadingZone_Deactivate (*Deactivate an autoloading zone*) (*$GROUP=User,$CAT=User,$GROUPICON=User.png,$CATICON=User.png*)
	VAR_INPUT
		Execute : {REDUND_UNREPLICABLE} BOOL; (* Execution of the function block begins on a rising edge of this input.	*)
		ZoneID : {REDUND_UNREPLICABLE} USINT; (* zone ID: >0 for deactivation*)
	END_VAR
	VAR_OUTPUT
		Done : {REDUND_UNREPLICABLE} BOOL; (* Execution successful. Function block is finished*)
		Busy : {REDUND_UNREPLICABLE} BOOL; (* Function block is active and must continue to be called.*)
		Aborted : {REDUND_UNREPLICABLE} BOOL; (* Command aborted by another command*)
		Error : {REDUND_UNREPLICABLE} BOOL; (* Error occurred during execution.*)
		ErrorID : {REDUND_UNREPLICABLE} UINT; (* Error number*)
	END_VAR
	VAR_IN_OUT
		PM_Controller : PMControllerType; (*Tracks state of the entire PMC system*)
	END_VAR
	VAR
		PMCFuncInfo : {REDUND_UNREPLICABLE} PMCFuncInfoType;
		timeout : {REDUND_UNREPLICABLE} UINT;
		cmdHB : {REDUND_UNREPLICABLE} INT;
		nTemp : {REDUND_UNREPLICABLE} DWORD;
		DummyDone : {REDUND_UNREPLICABLE} BOOL;
	END_VAR
	VAR CONSTANT
		Mode : USINT := 3; (* 3: deactivate zone*)
		cmdID : UINT := 3078;
	END_VAR
END_FUNCTION_BLOCK

{REDUND_ERROR} {REDUND_UNREPLICABLE} FUNCTION_BLOCK PMC_AutoLoadingZone_Delete (*deletes one or all autoloading zone(s)*) (*$GROUP=User,$CAT=User,$GROUPICON=User.png,$CATICON=User.png*)
	VAR_INPUT
		Execute : {REDUND_UNREPLICABLE} BOOL; (* Execution of the function block begins on a rising edge of this input.	*)
		ZoneID : {REDUND_UNREPLICABLE} USINT; (* zone ID: 0 - delete all zone, >0 - delete single zone *)
	END_VAR
	VAR_OUTPUT
		Done : {REDUND_UNREPLICABLE} BOOL; (* Execution successful. Function block is finished*)
		Busy : {REDUND_UNREPLICABLE} BOOL; (* Function block is active and must continue to be called.*)
		Aborted : {REDUND_UNREPLICABLE} BOOL; (* Command aborted by another command*)
		Error : {REDUND_UNREPLICABLE} BOOL; (* Error occurred during execution.*)
		ErrorID : {REDUND_UNREPLICABLE} UINT; (* Error number*)
	END_VAR
	VAR_IN_OUT
		PM_Controller : PMControllerType; (*Tracks state of the entire PMC system*)
	END_VAR
	VAR
		PMCFuncInfo : {REDUND_UNREPLICABLE} PMCFuncInfoType;
		timeout : {REDUND_UNREPLICABLE} UINT;
		cmdHB : {REDUND_UNREPLICABLE} INT;
		nTemp : {REDUND_UNREPLICABLE} DWORD;
		DummyDone : {REDUND_UNREPLICABLE} BOOL;
	END_VAR
	VAR CONSTANT
		Mode : USINT := 1; (* 1: delete zone*)
		cmdID : UINT := 3078;
	END_VAR
END_FUNCTION_BLOCK

{REDUND_ERROR} {REDUND_UNREPLICABLE} FUNCTION_BLOCK PMC_AutoLoadingZone_GetStatus (*Get status of an autoloading zone*) (*$GROUP=User,$CAT=User,$GROUPICON=User.png,$CATICON=User.png*)
	VAR_INPUT
		Execute : {REDUND_UNREPLICABLE} BOOL; (* Execution of the function block begins on a rising edge of this input.*)
		ZoneID : {REDUND_UNREPLICABLE} USINT; (* ID of zone that will be released*)
	END_VAR
	VAR_OUTPUT
		Done : {REDUND_UNREPLICABLE} BOOL; (* Execution successful. Function block is finished*)
		Busy : {REDUND_UNREPLICABLE} BOOL; (* Function block is active and must continue to be called.*)
		Aborted : {REDUND_UNREPLICABLE} BOOL; (* Command aborted by another command*)
		Error : {REDUND_UNREPLICABLE} BOOL; (* Error occurred during execution.*)
		ErrorID : {REDUND_UNREPLICABLE} UINT; (* Error number*)
		ZoneState : {REDUND_UNREPLICABLE} USINT; (* 0: undefined, 1: defined, 2: unloading zone, 3: loading zone*)
		EntranceExitState : {REDUND_UNREPLICABLE} USINT; (* 0: busy, 1: ready*)
		numXbots : {REDUND_UNREPLICABLE} USINT; (* # of xbots in the zone*)
		xbotID : {REDUND_UNREPLICABLE} USINT; (* xbot ID added to unloading zone or ready to fetch from loading zone *)
		ZoneX : {REDUND_UNREPLICABLE} REAL; (* X coordinate of entrance or exit (m)*)
		ZoneY : {REDUND_UNREPLICABLE} REAL; (* Y coordinate of entrance or exit (m) *)
	END_VAR
	VAR_IN_OUT
		PM_Controller : PMControllerType; (*Tracks state of the entire PMC system*)
	END_VAR
	VAR
		PMCFuncInfo : {REDUND_UNREPLICABLE} PMCFuncInfoType;
		timeout : {REDUND_UNREPLICABLE} UINT;
		cmdHB : {REDUND_UNREPLICABLE} INT;
		nTemp : {REDUND_UNREPLICABLE} DWORD;
		DummyDone : {REDUND_UNREPLICABLE} BOOL;
	END_VAR
	VAR CONSTANT
		cmdID : UINT := 3081;
	END_VAR
END_FUNCTION_BLOCK

{REDUND_ERROR} {REDUND_UNREPLICABLE} FUNCTION_BLOCK PMC_AutoLoadingZone_UnloadXbot (*Sends an xbot to an auto loading zone*) (*$GROUP=User,$CAT=User,$GROUPICON=User.png,$CATICON=User.png*)
	VAR_INPUT
		Execute : {REDUND_UNREPLICABLE} BOOL; (* Execution of the function block begins on a rising edge of this input.*)
		ZoneID : {REDUND_UNREPLICABLE} USINT; (* ID of zone that xbot will be sent to*)
		XbotID : {REDUND_UNREPLICABLE} USINT; (* ID of xbot to send to zone*)
	END_VAR
	VAR_OUTPUT
		Done : {REDUND_UNREPLICABLE} BOOL; (* Execution successful. Function block is finished*)
		Busy : {REDUND_UNREPLICABLE} BOOL; (* Function block is active and must continue to be called.*)
		Aborted : {REDUND_UNREPLICABLE} BOOL; (* Command aborted by another command*)
		Error : {REDUND_UNREPLICABLE} BOOL; (* Error occurred during execution.*)
		ErrorID : {REDUND_UNREPLICABLE} UINT; (* Error number*)
	END_VAR
	VAR_IN_OUT
		PM_Controller : PMControllerType; (*Tracks state of the entire PMC system*)
	END_VAR
	VAR
		PMCFuncInfo : {REDUND_UNREPLICABLE} PMCFuncInfoType;
		timeout : {REDUND_UNREPLICABLE} UINT;
		cmdHB : {REDUND_UNREPLICABLE} INT;
		nTemp : {REDUND_UNREPLICABLE} DWORD;
		DummyDone : {REDUND_UNREPLICABLE} BOOL;
	END_VAR
	VAR CONSTANT
		cmdID : UINT := 3079;
	END_VAR
END_FUNCTION_BLOCK

{REDUND_ERROR} {REDUND_UNREPLICABLE} FUNCTION_BLOCK PMC_AutoLoadingZon_HoldZoneReady (*Waits until the zone is ready (returns immediantly if zone is not activated)*) (*$GROUP=User,$CAT=User,$GROUPICON=User.png,$CATICON=User.png*)
	VAR_INPUT
		Execute : {REDUND_UNREPLICABLE} BOOL; (* Execution of the function block begins on a rising edge of this input.*)
		ZoneID : {REDUND_UNREPLICABLE} USINT; (* ID of zone that will be released*)
	END_VAR
	VAR_OUTPUT
		Done : {REDUND_UNREPLICABLE} BOOL; (* Execution successful. Function block is finished*)
		Busy : {REDUND_UNREPLICABLE} BOOL; (* Function block is active and must continue to be called.*)
		Aborted : {REDUND_UNREPLICABLE} BOOL; (* Command aborted by another command*)
		Error : {REDUND_UNREPLICABLE} BOOL; (* Error occurred during execution.*)
		ErrorID : {REDUND_UNREPLICABLE} UINT; (* Error number*)
		ZoneState : {REDUND_UNREPLICABLE} USINT; (* 0: undefined, 1: defined, 2: unloading zone, 3: loading zone*)
		EntranceExitState : {REDUND_UNREPLICABLE} USINT; (* 0: busy, 1: ready*)
		numXbots : {REDUND_UNREPLICABLE} USINT; (* # of xbots in the zone*)
		xbotID : {REDUND_UNREPLICABLE} USINT; (* xbot ID added to unloading zone or ready to fetch from loading zone *)
		ZoneX : {REDUND_UNREPLICABLE} REAL; (* X coordinate of entrance or exit (m)*)
		ZoneY : {REDUND_UNREPLICABLE} REAL; (* Y coordinate of entrance or exit (m) *)
	END_VAR
	VAR_IN_OUT
		PM_Controller : PMControllerType; (*Tracks state of the entire PMC system*)
	END_VAR
	VAR
		CmdSta : {REDUND_UNREPLICABLE} INT := 0;
		PMC_GetZoneStatus_db : {REDUND_UNREPLICABLE} PMC_AutoLoadingZone_GetStatus;
		xbot_is_in_zone_or_error : {REDUND_UNREPLICABLE} BOOL;
	END_VAR
END_FUNCTION_BLOCK

{REDUND_ERROR} {REDUND_UNREPLICABLE} FUNCTION_BLOCK PMC_AutoLoadZone_LoadZoneClear (*Release an autoloading zone exit*) (*$GROUP=User,$CAT=User,$GROUPICON=User.png,$CATICON=User.png*)
	VAR_INPUT
		Execute : {REDUND_UNREPLICABLE} BOOL; (* Execution of the function block begins on a rising edge of this input.*)
		ZoneID : {REDUND_UNREPLICABLE} USINT; (* ID of zone that will be released*)
	END_VAR
	VAR_OUTPUT
		Done : {REDUND_UNREPLICABLE} BOOL; (* Execution successful. Function block is finished*)
		Busy : {REDUND_UNREPLICABLE} BOOL; (* Function block is active and must continue to be called.*)
		Aborted : {REDUND_UNREPLICABLE} BOOL; (* Command aborted by another command*)
		Error : {REDUND_UNREPLICABLE} BOOL; (* Error occurred during execution.*)
		ErrorID : {REDUND_UNREPLICABLE} UINT; (* Error number*)
	END_VAR
	VAR_IN_OUT
		PM_Controller : PMControllerType; (*Tracks state of the entire PMC system*)
	END_VAR
	VAR
		PMCFuncInfo : {REDUND_UNREPLICABLE} PMCFuncInfoType;
		timeout : {REDUND_UNREPLICABLE} UINT;
		cmdHB : {REDUND_UNREPLICABLE} INT;
		nTemp : {REDUND_UNREPLICABLE} DWORD;
		DummyDone : {REDUND_UNREPLICABLE} BOOL;
	END_VAR
	VAR CONSTANT
		cmdID : UINT := 3080;
	END_VAR
END_FUNCTION_BLOCK

{REDUND_ERROR} FUNCTION_BLOCK PMC_AutoRefresh (*Background work for PMC communication, should be called once and only once per PLC cycle*) (*$GROUP=User,$CAT=User,$GROUPICON=User.png,$CATICON=User.png*)
	VAR_INPUT
		Enable : BOOL; (* Enable function block*)
	END_VAR
	VAR_OUTPUT
		Valid : BOOL; (* Function block executed successfully*)
	END_VAR
	VAR_IN_OUT
		PM_Controller : PMControllerType; (*Tracks state of the entire PMC system*)
	END_VAR
	VAR
		FrmCount : USINT;
		RegVal : UDINT;
		curXID : UDINT;
		EventID1 : UINT;
		EventID2 : UINT;
	END_VAR
END_FUNCTION_BLOCK

{REDUND_ERROR} {REDUND_UNREPLICABLE} FUNCTION_BLOCK PMC_BlockXbotGroup (*Block the motion buffers of the xbots in a group*) (*$GROUP=User,$CAT=User,$GROUPICON=User.png,$CATICON=User.png*)
	VAR_INPUT
		Execute : {REDUND_UNREPLICABLE} BOOL; (* Execution of the function block begins on a rising edge of this input.*)
		GroupID : {REDUND_UNREPLICABLE} USINT; (* 0: block all groups; >0: block specific group*)
		IsBlock : {REDUND_UNREPLICABLE} BOOL; (* False: unblock the group(s); True: block the group(s)*)
	END_VAR
	VAR_OUTPUT
		Done : {REDUND_UNREPLICABLE} BOOL; (* Execution successful. Function block is finished*)
		Busy : {REDUND_UNREPLICABLE} BOOL; (* Function block is active and must continue to be called.*)
		Aborted : {REDUND_UNREPLICABLE} BOOL; (* Command aborted by another command*)
		Error : {REDUND_UNREPLICABLE} BOOL; (* Error occurred during execution.*)
		ErrorID : {REDUND_UNREPLICABLE} UINT; (* Error number*)
	END_VAR
	VAR_IN_OUT
		PM_Controller : PMControllerType; (*Tracks state of the entire PMC system*)
	END_VAR
	VAR
		PMCFuncInfo : {REDUND_UNREPLICABLE} PMCFuncInfoType;
		timeout : {REDUND_UNREPLICABLE} UINT;
		cmdHB : {REDUND_UNREPLICABLE} INT;
		Level : {REDUND_UNREPLICABLE} USINT;
		DummyDone : {REDUND_UNREPLICABLE} BOOL;
	END_VAR
	VAR CONSTANT
		cmdID : UINT := 2838;
	END_VAR
END_FUNCTION_BLOCK

{REDUND_ERROR} {REDUND_UNREPLICABLE} FUNCTION_BLOCK PMC_BondXbotGroup (*Bond xbots in a group*) (*$GROUP=User,$CAT=User,$GROUPICON=User.png,$CATICON=User.png*)
	VAR_INPUT
		Execute : {REDUND_UNREPLICABLE} BOOL; (* Execution of the function block begins on a rising edge of this input.*)
		GroupID : {REDUND_UNREPLICABLE} USINT; (* 0: bond all groups; >0: bond specific group*)
		IsBond : {REDUND_UNREPLICABLE} BOOL; (* False: unbond group(s); True: bond group(s) *)
		Mode : {REDUND_UNREPLICABLE} USINT; (* 0: decouple mode;1: couple mode*)
	END_VAR
	VAR_OUTPUT
		Done : {REDUND_UNREPLICABLE} BOOL; (* Execution successful. Function block is finished*)
		Busy : {REDUND_UNREPLICABLE} BOOL; (* Function block is active and must continue to be called.*)
		Aborted : {REDUND_UNREPLICABLE} BOOL; (* Command aborted by another command*)
		Error : {REDUND_UNREPLICABLE} BOOL; (* Error occurred during execution.*)
		ErrorID : {REDUND_UNREPLICABLE} UINT; (* Error number*)
	END_VAR
	VAR_IN_OUT
		PM_Controller : PMControllerType; (*Tracks state of the entire PMC system*)
	END_VAR
	VAR
		PMCFuncInfo : {REDUND_UNREPLICABLE} PMCFuncInfoType;
		timeout : {REDUND_UNREPLICABLE} UINT;
		cmdHB : {REDUND_UNREPLICABLE} INT;
		Level : {REDUND_UNREPLICABLE} USINT;
		DummyDone : {REDUND_UNREPLICABLE} BOOL;
	END_VAR
	VAR CONSTANT
		cmdID : UINT := 2838;
	END_VAR
END_FUNCTION_BLOCK

{REDUND_ERROR} {REDUND_UNREPLICABLE} FUNCTION_BLOCK PMC_CamMotion (*Slave the axes of a slave xbot to the axes of one or more master xbots via cams*) (*$GROUP=User,$CAT=User,$GROUPICON=User.png,$CATICON=User.png*)
	VAR_INPUT
		Execute : {REDUND_UNREPLICABLE} BOOL; (* Execution of the function block begins on a rising edge of this input.*)
		cmdLB : {REDUND_UNREPLICABLE} UINT; (* label to be associated with this command in the PMC*)
		Level : {REDUND_UNREPLICABLE} USINT; (* 0:Exit from cam mode;1: Enter cam mode*)
		SlaveXID : {REDUND_UNREPLICABLE} USINT; (* ID# of the slave xbot*)
		nAxis : {REDUND_UNREPLICABLE} USINT; (*	number of axes to cam together (up to 6)*)
		SlaveAID : {REDUND_UNREPLICABLE} ARRAY[0..6] OF USINT; (* slave axes 1: X; 2: Y; 3: Z; 4: Rx; 5: Ry; 6: Rz*)
		camID : {REDUND_UNREPLICABLE} ARRAY[0..6] OF USINT; (* ID#s of the cams to use*)
		MasterXID : {REDUND_UNREPLICABLE} ARRAY[0..6] OF USINT; (* master xbot ID#s*)
		MasterAID : {REDUND_UNREPLICABLE} ARRAY[0..6] OF USINT; (* master axes 1: X; 2: Y; 3: Z; 4: Rx; 5: Ry; 6: Rz*)
	END_VAR
	VAR_OUTPUT
		Done : {REDUND_UNREPLICABLE} BOOL; (* Execution successful. Function block is finished*)
		Busy : {REDUND_UNREPLICABLE} BOOL; (* Function block is active and must continue to be called.*)
		Aborted : {REDUND_UNREPLICABLE} BOOL; (* Command aborted by another command*)
		Error : {REDUND_UNREPLICABLE} BOOL; (* Error occurred during execution.*)
		ErrorID : {REDUND_UNREPLICABLE} UINT; (* Error number*)
	END_VAR
	VAR_IN_OUT
		PM_Controller : PMControllerType; (*Tracks state of the entire PMC system*)
	END_VAR
	VAR
		PMCFuncInfo : {REDUND_UNREPLICABLE} PMCFuncInfoType;
		timeout : {REDUND_UNREPLICABLE} UINT;
		cmdHB : {REDUND_UNREPLICABLE} INT;
		axisNum : {REDUND_UNREPLICABLE} USINT;
		xIndex : {REDUND_UNREPLICABLE} SINT;
		DummyDone : {REDUND_UNREPLICABLE} BOOL;
	END_VAR
	VAR CONSTANT
		cmdID : UINT := 2834;
		maxNAxis : SINT := 7;
	END_VAR
END_FUNCTION_BLOCK

{REDUND_ERROR} {REDUND_UNREPLICABLE} FUNCTION_BLOCK PMC_CamMotionAdvanced (*Slave the axes of a slave xbot to the axes of one or more master xbots via cams with more advanced options*) (*$GROUP=User,$CAT=User,$GROUPICON=User.png,$CATICON=User.png*)
	VAR_INPUT
		Execute : {REDUND_UNREPLICABLE} BOOL; (* Execution of the function block begins on a rising edge of this input.*)
		cmdLB : {REDUND_UNREPLICABLE} UINT; (* label to be associated with this command in the PMC*)
		Level : {REDUND_UNREPLICABLE} USINT; (* 0:Exit from cam mode;1: Enter cam mode*)
		SlaveXID : {REDUND_UNREPLICABLE} USINT; (* ID# of the slave xbot*)
		nAxis : {REDUND_UNREPLICABLE} USINT; (*	number of axes to cam together (up to 4)*)
		SlaveAID : {REDUND_UNREPLICABLE} ARRAY[0..3] OF USINT; (* slave axes 1: X; 2: Y; 3: Z; 4: Rx; 5: Ry; 6: Rz*)
		camID : {REDUND_UNREPLICABLE} ARRAY[0..3] OF USINT; (* ID#s of the cams to use*)
		MasterXID : {REDUND_UNREPLICABLE} ARRAY[0..3] OF USINT; (* master xbot ID#s*)
		MasterAID : {REDUND_UNREPLICABLE} ARRAY[0..3] OF USINT; (* master axes 1: X; 2: Y; 3: Z; 4: Rx; 5: Ry; 6: Rz*)
		MasterAOffset : {REDUND_UNREPLICABLE} ARRAY[0..3] OF REAL; (* master axis offsets (m)*)
		SlaveAOffset : {REDUND_UNREPLICABLE} ARRAY[0..3] OF REAL; (* slave axis offsets (m)*)
		MasterAScaling : {REDUND_UNREPLICABLE} ARRAY[0..3] OF REAL; (* master axis scaling, positive only (m)*)
		SlaveAScaling : {REDUND_UNREPLICABLE} ARRAY[0..3] OF REAL; (* slave axis scaling, positive only (m)*)
		CamMode : {REDUND_UNREPLICABLE} ARRAY[0..3] OF USINT; (* cam mode; 0: auto start, 1: cyclic, 2: start once *)
		MasterOffsetMode : {REDUND_UNREPLICABLE} ARRAY[0..3] OF USINT; (* 0: absolute, 1: relative*)
	END_VAR
	VAR_OUTPUT
		Done : {REDUND_UNREPLICABLE} BOOL; (* Execution successful. Function block is finished*)
		Busy : {REDUND_UNREPLICABLE} BOOL; (* Function block is active and must continue to be called.*)
		Aborted : {REDUND_UNREPLICABLE} BOOL; (* Command aborted by another command*)
		Error : {REDUND_UNREPLICABLE} BOOL; (* Error occurred during execution.*)
		ErrorID : {REDUND_UNREPLICABLE} UINT; (* Error number*)
	END_VAR
	VAR_IN_OUT
		PM_Controller : PMControllerType; (*Tracks state of the entire PMC system*)
	END_VAR
	VAR
		PMCFuncInfo : {REDUND_UNREPLICABLE} PMCFuncInfoType;
		timeout : {REDUND_UNREPLICABLE} UINT;
		MasterDirection : {REDUND_UNREPLICABLE} ARRAY[0..3] OF USINT; (* 0: master can move in bi-direction; 1: master can only move forward; 2: master can only move backward*)
		cmdHB : {REDUND_UNREPLICABLE} INT;
		axisNum : {REDUND_UNREPLICABLE} USINT;
		xIndex : {REDUND_UNREPLICABLE} SINT;
		DummyDone : {REDUND_UNREPLICABLE} BOOL;
		ModeByte : {REDUND_UNREPLICABLE} USINT;
	END_VAR
	VAR CONSTANT
		cmdID : UINT := 2855;
		maxNAxis : SINT := 4;
	END_VAR
END_FUNCTION_BLOCK

{REDUND_ERROR} {REDUND_UNREPLICABLE} FUNCTION_BLOCK PMC_ClearMacro (*clear commands stored in a macro*) (*$GROUP=User,$CAT=User,$GROUPICON=User.png,$CATICON=User.png*)
	VAR_INPUT
		Execute : {REDUND_UNREPLICABLE} BOOL; (* Execution of the function block begins on a rising edge of this input.*)
		MacroID : {REDUND_UNREPLICABLE} USINT; (* ID# of the macro to be cleared. Macro IDs are 128 - 191*)
	END_VAR
	VAR_OUTPUT
		Done : {REDUND_UNREPLICABLE} BOOL; (* Execution successful. Function block is finished*)
		Busy : {REDUND_UNREPLICABLE} BOOL; (* Function block is active and must continue to be called.*)
		Aborted : {REDUND_UNREPLICABLE} BOOL; (* Command aborted by another command*)
		Error : {REDUND_UNREPLICABLE} BOOL; (* Error occurred during execution.*)
		ErrorID : {REDUND_UNREPLICABLE} UINT; (* Error number*)
	END_VAR
	VAR_IN_OUT
		PM_Controller : PMControllerType; (*Tracks state of the entire PMC system*)
	END_VAR
	VAR
		PMCFuncInfo : {REDUND_UNREPLICABLE} PMCFuncInfoType;
		timeout : {REDUND_UNREPLICABLE} UINT;
		cmdHB : {REDUND_UNREPLICABLE} INT;
		DummyDone : {REDUND_UNREPLICABLE} BOOL;
	END_VAR
	VAR CONSTANT
		cmdID : UINT := 2839;
		Level : USINT := 0;
	END_VAR
END_FUNCTION_BLOCK

{REDUND_ERROR} FUNCTION PMC_CmdProcessor : BOOL (*internal function used by other PMC function blocks, end user should NEVER call this themselves*) (*$GROUP=User,$CAT=User,$GROUPICON=User.png,$CATICON=User.png*)
	VAR_INPUT
		Execute : BOOL; (* Execution of the function block begins on a rising edge of this input.*)
		ExecutionLocation : USINT; (* 0: beginning of function block call, 1: end of function block call, 2: timeout*)
		EventCommand : BOOL; (* command supports events*)
	END_VAR
	VAR_IN_OUT
		PM_Controller : PMControllerType; (* Tracks state of the entire PMC system*)
		PMCFuncInfo : PMCFuncInfoType; (* Tracks state of a single PMC function block instance *)
		Ack : BOOL; (* PMC has received the command*)
		Done : BOOL; (* PMC has finished executing the command*)
		Busy : BOOL; (* Function block is active and must continue to be called.*)
		Error : BOOL; (* Command aborted by another command*)
		ErrorID : UINT; (* Error occurred during execution.*)
		Aborted : BOOL; (* Error number*)
	END_VAR
	VAR
		TicketCompleted : BOOL;
		CmdCounterFromPMC : USINT;
		CmdCounterToPMC : USINT;
		CmdID : UINT;
		CmdIDRtn : UINT;
		nextTicketIndex : USINT;
		tempCounter : INT;
		loopcounter : UDINT;
		EventIDFound : BOOL;
	END_VAR
END_FUNCTION

{REDUND_ERROR} {REDUND_UNREPLICABLE} FUNCTION_BLOCK PMC_ConfigDI2Reset (*Configure PMC digital inputs to reset PMC digital outputs *) (*$GROUP=User,$CAT=User,$GROUPICON=User.png,$CATICON=User.png*)
	VAR_INPUT
		Execute : {REDUND_UNREPLICABLE} BOOL; (* Execution of the function block begins on a rising edge of this input.*)
		nDI : {REDUND_UNREPLICABLE} USINT; (* number of digital inputs to configure (up to 22)*)
		DiID : {REDUND_UNREPLICABLE} ARRAY[0..21] OF USINT; (* Array of digital input ID to configure*)
		RstDoID : {REDUND_UNREPLICABLE} ARRAY[0..21] OF USINT; (* Array of digital output ID#s to reset*)
	END_VAR
	VAR_OUTPUT
		Done : {REDUND_UNREPLICABLE} BOOL; (* Execution successful. Function block is finished*)
		Busy : {REDUND_UNREPLICABLE} BOOL; (* Function block is active and must continue to be called.*)
		Aborted : {REDUND_UNREPLICABLE} BOOL; (* Command aborted by another command*)
		Error : {REDUND_UNREPLICABLE} BOOL; (* Error occurred during execution.*)
		ErrorID : {REDUND_UNREPLICABLE} UINT; (* Error number*)
	END_VAR
	VAR_IN_OUT
		PM_Controller : PMControllerType; (*Tracks state of the entire PMC system*)
	END_VAR
	VAR
		PMCFuncInfo : {REDUND_UNREPLICABLE} PMCFuncInfoType;
		timeout : {REDUND_UNREPLICABLE} UINT;
		cmdHB : {REDUND_UNREPLICABLE} INT;
		diNum : {REDUND_UNREPLICABLE} USINT;
		xIndex : {REDUND_UNREPLICABLE} SINT;
		DummyDone : {REDUND_UNREPLICABLE} BOOL;
	END_VAR
	VAR CONSTANT
		cmdID : UINT := 2844;
		maxNDi : SINT := 22;
		Type_ : USINT := 1;
	END_VAR
END_FUNCTION_BLOCK

{REDUND_ERROR} {REDUND_UNREPLICABLE} FUNCTION_BLOCK PMC_ConfigDI2RunMacro (*Configure PMC digital inputs to trigger xbots to run macros*) (*$GROUP=User,$CAT=User,$GROUPICON=User.png,$CATICON=User.png*)
	VAR_INPUT
		Execute : {REDUND_UNREPLICABLE} BOOL; (* Execution of the function block begins on a rising edge of this input.*)
		nDI : {REDUND_UNREPLICABLE} USINT; (* number of digital inputs to configure (up to 22)*)
		DiID : {REDUND_UNREPLICABLE} ARRAY[0..21] OF USINT; (* Array of digital input ID to configure*)
		MacroID : {REDUND_UNREPLICABLE} ARRAY[0..21] OF USINT; (* Array of macro ID#s to run. Macro IDs are 128 - 191*)
		XbotID : {REDUND_UNREPLICABLE} ARRAY[0..21] OF USINT; (* Array of ID#s to run the macros *)
	END_VAR
	VAR_OUTPUT
		Done : {REDUND_UNREPLICABLE} BOOL; (* Execution successful. Function block is finished*)
		Busy : {REDUND_UNREPLICABLE} BOOL; (* Function block is active and must continue to be called.*)
		Aborted : {REDUND_UNREPLICABLE} BOOL; (* Command aborted by another command*)
		Error : {REDUND_UNREPLICABLE} BOOL; (* Error occurred during execution.*)
		ErrorID : {REDUND_UNREPLICABLE} UINT; (* Error number*)
	END_VAR
	VAR_IN_OUT
		PM_Controller : PMControllerType; (*Tracks state of the entire PMC system*)
	END_VAR
	VAR
		PMCFuncInfo : {REDUND_UNREPLICABLE} PMCFuncInfoType;
		timeout : {REDUND_UNREPLICABLE} UINT;
		cmdHB : {REDUND_UNREPLICABLE} INT;
		diNum : {REDUND_UNREPLICABLE} USINT;
		xIndex : {REDUND_UNREPLICABLE} SINT;
		DummyDone : {REDUND_UNREPLICABLE} BOOL;
	END_VAR
	VAR CONSTANT
		cmdID : UINT := 2844;
		maxNDi : SINT := 22;
		Type_ : USINT := 2;
	END_VAR
END_FUNCTION_BLOCK

{REDUND_ERROR} {REDUND_UNREPLICABLE} FUNCTION_BLOCK PMC_ConfigDI2Trigger (*Configure PMC digital inputs to act as macro triggers *) (*$GROUP=User,$CAT=User,$GROUPICON=User.png,$CATICON=User.png*)
	VAR_INPUT
		Execute : {REDUND_UNREPLICABLE} BOOL; (* Execution of the function block begins on a rising edge of this input.*)
		nDI : {REDUND_UNREPLICABLE} USINT; (* Number of digital inputs to configure (up to 22)*)
		DiID : {REDUND_UNREPLICABLE} ARRAY[0..21] OF USINT; (* Array of digital input ID to configure*)
	END_VAR
	VAR_OUTPUT
		Done : {REDUND_UNREPLICABLE} BOOL; (* Execution successful. Function block is finished*)
		Busy : {REDUND_UNREPLICABLE} BOOL; (* Function block is active and must continue to be called.*)
		Aborted : {REDUND_UNREPLICABLE} BOOL; (* Command aborted by another command*)
		Error : {REDUND_UNREPLICABLE} BOOL; (* Error occurred during execution.*)
		ErrorID : {REDUND_UNREPLICABLE} UINT; (* Error number*)
	END_VAR
	VAR_IN_OUT
		PM_Controller : PMControllerType; (*Tracks state of the entire PMC system*)
	END_VAR
	VAR
		PMCFuncInfo : {REDUND_UNREPLICABLE} PMCFuncInfoType;
		timeout : {REDUND_UNREPLICABLE} UINT;
		cmdHB : {REDUND_UNREPLICABLE} INT;
		diNum : {REDUND_UNREPLICABLE} USINT;
		xIndex : {REDUND_UNREPLICABLE} SINT;
		DummyDone : {REDUND_UNREPLICABLE} BOOL;
	END_VAR
	VAR CONSTANT
		cmdID : UINT := 2844;
		maxNDi : SINT := 22;
		Type_ : USINT := 0;
	END_VAR
END_FUNCTION_BLOCK

{REDUND_ERROR} {REDUND_UNREPLICABLE} FUNCTION_BLOCK PMC_ConfigDO2CmdLb (*Configure digital outputs to set on command labels*) (*$GROUP=User,$CAT=User,$GROUPICON=User.png,$CATICON=User.png*)
	VAR_INPUT
		Execute : {REDUND_UNREPLICABLE} BOOL; (* Execution of the function block begins on a rising edge of this input.*)
		nDO : {REDUND_UNREPLICABLE} USINT; (* number of digital outputs to configure (up to 5)*)
		DoID : {REDUND_UNREPLICABLE} ARRAY[0..4] OF USINT; (* array of digital output ID#s to configure*)
		XbotID : {REDUND_UNREPLICABLE} ARRAY[0..4] OF USINT; (* array of xbot ID#s to monitor for the command labels *)
		CmdLb : {REDUND_UNREPLICABLE} ARRAY[0..4] OF UINT; (* array of command labels to set on*)
		Type_ : {REDUND_UNREPLICABLE} ARRAY[0..4] OF USINT; (* when to set the digital output 0: Cmd Label Start; 1: Cmd Label End; 2: Cmd Label state*)
	END_VAR
	VAR_OUTPUT
		Done : {REDUND_UNREPLICABLE} BOOL; (* Execution successful. Function block is finished*)
		Busy : {REDUND_UNREPLICABLE} BOOL; (* Function block is active and must continue to be called.*)
		Aborted : {REDUND_UNREPLICABLE} BOOL; (* Command aborted by another command*)
		Error : {REDUND_UNREPLICABLE} BOOL; (* Error occurred during execution.*)
		ErrorID : {REDUND_UNREPLICABLE} UINT; (* Error number*)
	END_VAR
	VAR_IN_OUT
		PM_Controller : PMControllerType; (*Tracks state of the entire PMC system*)
	END_VAR
	VAR
		PMCFuncInfo : {REDUND_UNREPLICABLE} PMCFuncInfoType;
		timeout : {REDUND_UNREPLICABLE} UINT;
		cmdHB : {REDUND_UNREPLICABLE} INT;
		doNum : {REDUND_UNREPLICABLE} USINT;
		xIndex : {REDUND_UNREPLICABLE} SINT;
		eventID : {REDUND_UNREPLICABLE} USINT;
		DummyDone : {REDUND_UNREPLICABLE} BOOL;
	END_VAR
	VAR CONSTANT
		cmdID : UINT := 2843;
		maxNDo : SINT := 5;
	END_VAR
END_FUNCTION_BLOCK

{REDUND_ERROR} {REDUND_UNREPLICABLE} FUNCTION_BLOCK PMC_ConfigDO2Disp (*Configure digital outputs to set on xbot displacements*) (*$GROUP=User,$CAT=User,$GROUPICON=User.png,$CATICON=User.png*)
	VAR_INPUT
		Execute : {REDUND_UNREPLICABLE} BOOL; (* Execution of the function block begins on a rising edge of this input.*)
		nDO : {REDUND_UNREPLICABLE} USINT; (* number of digital outputs to configure (up to 5)*)
		DoID : {REDUND_UNREPLICABLE} ARRAY[0..4] OF USINT; (* array of digital output ID#s to configure *)
		XbotID : {REDUND_UNREPLICABLE} ARRAY[0..4] OF USINT; (* array of xbot ID#s to monitor for displacement*)
		Type_ : {REDUND_UNREPLICABLE} ARRAY[0..4] OF USINT; (* 0: Positive Cross; 1: Negative Cross; 2: State*)
		Mode : {REDUND_UNREPLICABLE} ARRAY[0..4] OF USINT; (* 0: X only; 1: Y only ; 2: XFactor*X + YFactor*Y*)
		Threshold : {REDUND_UNREPLICABLE} ARRAY[0..4] OF REAL; (* Thresholds for output trigger in meters*)
		XFactor : {REDUND_UNREPLICABLE} ARRAY[0..4] OF REAL; (* XFactor used for Mode #2*)
		YFactor : {REDUND_UNREPLICABLE} ARRAY[0..4] OF REAL; (* YFactor used for Mode #2*)
	END_VAR
	VAR_OUTPUT
		Done : {REDUND_UNREPLICABLE} BOOL; (* Execution successful. Function block is finished*)
		Busy : {REDUND_UNREPLICABLE} BOOL; (* Function block is active and must continue to be called.*)
		Aborted : {REDUND_UNREPLICABLE} BOOL; (* Command aborted by another command*)
		Error : {REDUND_UNREPLICABLE} BOOL; (* Error occurred during execution.*)
		ErrorID : {REDUND_UNREPLICABLE} UINT; (* Error number*)
	END_VAR
	VAR_IN_OUT
		PM_Controller : PMControllerType; (*Tracks state of the entire PMC system*)
	END_VAR
	VAR
		PMCFuncInfo : {REDUND_UNREPLICABLE} PMCFuncInfoType;
		timeout : {REDUND_UNREPLICABLE} UINT;
		cmdHB : {REDUND_UNREPLICABLE} INT;
		doNum : {REDUND_UNREPLICABLE} USINT;
		xIndex : {REDUND_UNREPLICABLE} SINT;
		eventID : {REDUND_UNREPLICABLE} USINT;
		DummyDone : {REDUND_UNREPLICABLE} BOOL;
	END_VAR
	VAR CONSTANT
		cmdID : UINT := 2843;
		maxNDo : SINT := 5;
	END_VAR
END_FUNCTION_BLOCK

{REDUND_ERROR} {REDUND_UNREPLICABLE} FUNCTION_BLOCK PMC_ConfigDO2Force (*Configure digital outputs to set on xbot force*) (*$GROUP=User,$CAT=User,$GROUPICON=User.png,$CATICON=User.png*)
	VAR_INPUT
		Execute : {REDUND_UNREPLICABLE} BOOL; (* Execution of the function block begins on a rising edge of this input.*)
		nDO : {REDUND_UNREPLICABLE} USINT; (* number of digital outputs to configure (up to 5)*)
		DoID : {REDUND_UNREPLICABLE} ARRAY[0..4] OF USINT; (* array of digital output ID#s to configure *)
		XbotID : {REDUND_UNREPLICABLE} ARRAY[0..4] OF USINT; (* array of xbot ID#s to monitor for force*)
		Type_ : {REDUND_UNREPLICABLE} ARRAY[0..4] OF USINT; (* 0: Positive Cross; 1: Negative Cross; 2: State*)
		AxisID : {REDUND_UNREPLICABLE} ARRAY[0..4] OF USINT; (* 1: X axis; 2: Y axis; 3: Z axis; 4: Rx; 5: Ry; 6: Rz;*)
		Threshold : {REDUND_UNREPLICABLE} ARRAY[0..4] OF REAL; (* Thresholds for output trigger in Newtons/Newton*Meters*)
	END_VAR
	VAR_OUTPUT
		Done : {REDUND_UNREPLICABLE} BOOL; (* Execution successful. Function block is finished*)
		Busy : {REDUND_UNREPLICABLE} BOOL; (* Function block is active and must continue to be called.*)
		Aborted : {REDUND_UNREPLICABLE} BOOL; (* Command aborted by another command*)
		Error : {REDUND_UNREPLICABLE} BOOL; (* Error occurred during execution.*)
		ErrorID : {REDUND_UNREPLICABLE} UINT; (* Error number*)
	END_VAR
	VAR_IN_OUT
		PM_Controller : PMControllerType; (*Tracks state of the entire PMC system*)
	END_VAR
	VAR
		PMCFuncInfo : {REDUND_UNREPLICABLE} PMCFuncInfoType;
		timeout : {REDUND_UNREPLICABLE} UINT;
		cmdHB : {REDUND_UNREPLICABLE} INT;
		doNum : {REDUND_UNREPLICABLE} USINT;
		xIndex : {REDUND_UNREPLICABLE} SINT;
		eventID : {REDUND_UNREPLICABLE} USINT;
		DummyDone : {REDUND_UNREPLICABLE} BOOL;
	END_VAR
	VAR CONSTANT
		cmdID : UINT := 2843;
		maxNDo : SINT := 5;
	END_VAR
END_FUNCTION_BLOCK

{REDUND_ERROR} {REDUND_UNREPLICABLE} FUNCTION_BLOCK PMC_ConfigDO2Motion (*Configure digital outputs to set on xbot motion*) (*$GROUP=User,$CAT=User,$GROUPICON=User.png,$CATICON=User.png*)
	VAR_INPUT
		Execute : {REDUND_UNREPLICABLE} BOOL; (* Execution of the function block begins on a rising edge of this input.*)
		nDO : {REDUND_UNREPLICABLE} USINT; (* number of digital outputs to configure (up to 5)*)
		DoID : {REDUND_UNREPLICABLE} ARRAY[0..4] OF USINT; (* array of digital output ID#s to configure *)
		XbotID : {REDUND_UNREPLICABLE} ARRAY[0..4] OF USINT; (* array of xbot ID#s to monitor for motion*)
		Type_ : {REDUND_UNREPLICABLE} ARRAY[0..4] OF USINT; (* 0: Motion Start; 1: Motion End; 2: Motion state*)
	END_VAR
	VAR_OUTPUT
		Done : {REDUND_UNREPLICABLE} BOOL; (* Execution successful. Function block is finished*)
		Busy : {REDUND_UNREPLICABLE} BOOL; (* Function block is active and must continue to be called.*)
		Aborted : {REDUND_UNREPLICABLE} BOOL; (* Command aborted by another command*)
		Error : {REDUND_UNREPLICABLE} BOOL; (* Error occurred during execution.*)
		ErrorID : {REDUND_UNREPLICABLE} UINT; (* Error number*)
	END_VAR
	VAR_IN_OUT
		PM_Controller : PMControllerType; (*Tracks state of the entire PMC system*)
	END_VAR
	VAR
		PMCFuncInfo : {REDUND_UNREPLICABLE} PMCFuncInfoType;
		timeout : {REDUND_UNREPLICABLE} UINT;
		cmdHB : {REDUND_UNREPLICABLE} INT;
		doNum : {REDUND_UNREPLICABLE} USINT;
		xIndex : {REDUND_UNREPLICABLE} SINT;
		eventID : {REDUND_UNREPLICABLE} USINT;
		DummyDone : {REDUND_UNREPLICABLE} BOOL;
	END_VAR
	VAR CONSTANT
		cmdID : UINT := 2843;
		maxNDo : SINT := 5;
	END_VAR
END_FUNCTION_BLOCK

{REDUND_ERROR} {REDUND_UNREPLICABLE} FUNCTION_BLOCK PMC_ConfigFBStream (*Configure feedback streams for xbots position or force*) (*$GROUP=User,$CAT=User,$GROUPICON=User.png,$CATICON=User.png*)
	VAR_INPUT
		Execute : {REDUND_UNREPLICABLE} BOOL; (* Execution of the function block begins on a rising edge of this input.*)
		nStm : {REDUND_UNREPLICABLE} USINT; (* number of feedback streams (up to 8)*)
		StmID : {REDUND_UNREPLICABLE} ARRAY[0..7] OF USINT; (* feedback stream ID*)
		XbotID : {REDUND_UNREPLICABLE} ARRAY[0..7] OF USINT; (* xbot ID# for the stream*)
		FBMode : {REDUND_UNREPLICABLE} ARRAY[0..7] OF USINT; (*	0: position; 1: force*)
	END_VAR
	VAR_OUTPUT
		Done : {REDUND_UNREPLICABLE} BOOL; (* Execution successful. Function block is finished*)
		Busy : {REDUND_UNREPLICABLE} BOOL; (* Function block is active and must continue to be called.*)
		Aborted : {REDUND_UNREPLICABLE} BOOL; (* Command aborted by another command*)
		Error : {REDUND_UNREPLICABLE} BOOL; (* Error occurred during execution.*)
		ErrorID : {REDUND_UNREPLICABLE} UINT; (* Error number*)
	END_VAR
	VAR_IN_OUT
		PM_Controller : PMControllerType; (*Tracks state of the entire PMC system*)
	END_VAR
	VAR
		PMCFuncInfo : {REDUND_UNREPLICABLE} PMCFuncInfoType;
		timeout : {REDUND_UNREPLICABLE} UINT;
		cmdHB : {REDUND_UNREPLICABLE} INT;
		stmNum : {REDUND_UNREPLICABLE} USINT;
		Index : {REDUND_UNREPLICABLE} SINT;
		DummyDone : {REDUND_UNREPLICABLE} BOOL;
	END_VAR
	VAR CONSTANT
		cmdID : UINT := 2828;
		maxNStm : SINT := 8;
	END_VAR
END_FUNCTION_BLOCK

{REDUND_ERROR} {REDUND_UNREPLICABLE} FUNCTION_BLOCK PMC_CreateXbotGroup (*Create a xbot group*) (*$GROUP=User,$CAT=User,$GROUPICON=User.png,$CATICON=User.png*)
	VAR_INPUT
		Execute : {REDUND_UNREPLICABLE} BOOL; (* Execution of the function block begins on a rising edge of this input.*)
		GroupID : {REDUND_UNREPLICABLE} USINT; (* must be greater than 0*)
		nXbots : {REDUND_UNREPLICABLE} USINT; (* number of xbots to be in the group (up to 32)*)
		XbotID : {REDUND_UNREPLICABLE} ARRAY[0..31] OF USINT; (* xbot ID#s to be in the group*)
	END_VAR
	VAR_OUTPUT
		Done : {REDUND_UNREPLICABLE} BOOL; (* Execution successful. Function block is finished*)
		Busy : {REDUND_UNREPLICABLE} BOOL; (* Function block is active and must continue to be called.*)
		Aborted : {REDUND_UNREPLICABLE} BOOL; (* Command aborted by another command*)
		Error : {REDUND_UNREPLICABLE} BOOL; (* Error occurred during execution.*)
		ErrorID : {REDUND_UNREPLICABLE} UINT; (* Error number*)
	END_VAR
	VAR_IN_OUT
		PM_Controller : PMControllerType; (*Tracks state of the entire PMC system*)
	END_VAR
	VAR
		PMCFuncInfo : {REDUND_UNREPLICABLE} PMCFuncInfoType;
		timeout : {REDUND_UNREPLICABLE} UINT;
		cmdHB : {REDUND_UNREPLICABLE} INT;
		xbotNum : {REDUND_UNREPLICABLE} USINT;
		xIndex : {REDUND_UNREPLICABLE} SINT;
		DummyDone : {REDUND_UNREPLICABLE} BOOL;
	END_VAR
	VAR CONSTANT
		cmdID : UINT := 2838;
		maxNXbot : SINT := 32;
		Level : USINT := 0;
	END_VAR
END_FUNCTION_BLOCK

{REDUND_ERROR} FUNCTION_BLOCK PMC_DeactivateXbots (*Deactivate all xbots*) (*$GROUP=User,$CAT=User,$GROUPICON=User.png,$CATICON=User.png*)
	VAR_INPUT
		Execute : {REDUND_UNREPLICABLE} BOOL; (* Execution of the function block begins on a rising edge of this input.*)
	END_VAR
	VAR_OUTPUT
		Ack : {REDUND_UNREPLICABLE} BOOL; (* Command has been received by PMC, any returned values can be used*)
		Done : {REDUND_UNREPLICABLE} BOOL; (* Xbots have finished deactivating*)
		Busy : {REDUND_UNREPLICABLE} BOOL; (* Function block is active and must continue to be called.*)
		Aborted : {REDUND_UNREPLICABLE} BOOL; (* Command aborted by another command*)
		Error : {REDUND_UNREPLICABLE} BOOL; (* Error occurred during execution.*)
		ErrorID : {REDUND_UNREPLICABLE} UINT; (* Error number*)
	END_VAR
	VAR_IN_OUT
		PM_Controller : PMControllerType; (*Tracks state of the entire PMC system*)
	END_VAR
	VAR
		PMCFuncInfo : {REDUND_UNREPLICABLE} PMCFuncInfoType;
		timeout : {REDUND_UNREPLICABLE} UINT;
		cmdHB : {REDUND_UNREPLICABLE} INT;
		requestEventID : BOOL;
	END_VAR
	VAR CONSTANT
		cmdID : UINT := 2570;
	END_VAR
END_FUNCTION_BLOCK

{REDUND_ERROR} {REDUND_UNREPLICABLE} FUNCTION_BLOCK PMC_DeleteXbotGroup (*delete a xbot group*) (*$GROUP=User,$CAT=User,$GROUPICON=User.png,$CATICON=User.png*)
	VAR_INPUT
		Execute : {REDUND_UNREPLICABLE} BOOL; (* Execution of the function block begins on a rising edge of this input.*)
		GroupID : {REDUND_UNREPLICABLE} USINT; (* 0: delete all groups; >0: delete specific group*)
	END_VAR
	VAR_OUTPUT
		Done : {REDUND_UNREPLICABLE} BOOL; (* Execution successful. Function block is finished*)
		Busy : {REDUND_UNREPLICABLE} BOOL; (* Function block is active and must continue to be called.*)
		Aborted : {REDUND_UNREPLICABLE} BOOL; (* Command aborted by another command*)
		Error : {REDUND_UNREPLICABLE} BOOL; (* Error occurred during execution.*)
		ErrorID : {REDUND_UNREPLICABLE} UINT; (* Error number*)
	END_VAR
	VAR_IN_OUT
		PM_Controller : PMControllerType; (*Tracks state of the entire PMC system*)
	END_VAR
	VAR
		PMCFuncInfo : {REDUND_UNREPLICABLE} PMCFuncInfoType;
		timeout : {REDUND_UNREPLICABLE} UINT;
		cmdHB : {REDUND_UNREPLICABLE} INT;
		DummyDone : {REDUND_UNREPLICABLE} BOOL;
	END_VAR
	VAR CONSTANT
		cmdID : UINT := 2838;
		Level : USINT := 1;
	END_VAR
END_FUNCTION_BLOCK

{REDUND_ERROR} {REDUND_UNREPLICABLE} FUNCTION_BLOCK PMC_ForceModeCtrl (*activate force mode control on a xbot*) (*$GROUP=User,$CAT=User,$GROUPICON=User.png,$CATICON=User.png*)
	VAR_INPUT
		Execute : {REDUND_UNREPLICABLE} BOOL; (* Execution of the function block begins on a rising edge of this input.*)
		Level : {REDUND_UNREPLICABLE} USINT; (* 0: Exit from force mode;1: Z force mode;2: X force mode;3: Y force mode;4: XY force mode*)
		XbotID : {REDUND_UNREPLICABLE} USINT; (* xbot ID# of the xbot to activate force mode control*)
		ForceX : {REDUND_UNREPLICABLE} REAL; (* force in X in Newtons*)
		ForceY : {REDUND_UNREPLICABLE} REAL; (* force in Y in Newtons*)
		ForceZ : {REDUND_UNREPLICABLE} REAL; (* force in Z in Newtons*)
	END_VAR
	VAR_OUTPUT
		Done : {REDUND_UNREPLICABLE} BOOL; (* Execution successful. Function block is finished*)
		Busy : {REDUND_UNREPLICABLE} BOOL; (* Function block is active and must continue to be called.*)
		Aborted : {REDUND_UNREPLICABLE} BOOL; (* Command aborted by another command*)
		Error : {REDUND_UNREPLICABLE} BOOL; (* Error occurred during execution.*)
		ErrorID : {REDUND_UNREPLICABLE} UINT; (* Error number*)
	END_VAR
	VAR_IN_OUT
		PM_Controller : PMControllerType; (*Tracks state of the entire PMC system*)
	END_VAR
	VAR
		PMCFuncInfo : {REDUND_UNREPLICABLE} PMCFuncInfoType;
		timeout : {REDUND_UNREPLICABLE} UINT;
		cmdHB : {REDUND_UNREPLICABLE} INT;
		DummyDone : {REDUND_UNREPLICABLE} BOOL;
	END_VAR
	VAR CONSTANT
		cmdID : UINT := 2833;
	END_VAR
END_FUNCTION_BLOCK

{REDUND_ERROR} {REDUND_UNREPLICABLE} FUNCTION_BLOCK PMC_GetBufferStatus (*Get status of a Xbot's motion buffer*) (*$GROUP=User,$CAT=User,$GROUPICON=User.png,$CATICON=User.png*)
	VAR_INPUT
		Execute : {REDUND_UNREPLICABLE} BOOL; (* Execution of the function block begins on a rising edge of this input.*)
		XbotID : {REDUND_UNREPLICABLE} USINT; (* Xbot ID# (>0)*)
	END_VAR
	VAR_OUTPUT
		Valid : {REDUND_UNREPLICABLE} BOOL; (* The function block's output values can be used.*)
		Busy : {REDUND_UNREPLICABLE} BOOL; (* Function block is active and must continue to be called.*)
		Aborted : {REDUND_UNREPLICABLE} BOOL; (* Command aborted by another command*)
		Error : {REDUND_UNREPLICABLE} BOOL; (* Error occurred during execution.*)
		ErrorID : {REDUND_UNREPLICABLE} UINT; (* Error number*)
		State : {REDUND_UNREPLICABLE} USINT; (* Buffer state; 0: unblocked; 1: blocked *)
		nCmds : {REDUND_UNREPLICABLE} UINT; (* number of commands in the buffer*)
		nextCmdLb : {REDUND_UNREPLICABLE} UINT; (* Command label of first command in the buffer*)
		newCmdLb : {REDUND_UNREPLICABLE} UINT; (* Command label of last command in the buffer*)
	END_VAR
	VAR_IN_OUT
		PM_Controller : PMControllerType; (*Tracks state of the entire PMC system*)
	END_VAR
	VAR
		PMCFuncInfo : {REDUND_UNREPLICABLE} PMCFuncInfoType;
		timeout : {REDUND_UNREPLICABLE} UINT;
		cmdHB : {REDUND_UNREPLICABLE} INT;
		DummyDone : {REDUND_UNREPLICABLE} BOOL;
	END_VAR
	VAR CONSTANT
		cmdID : UINT := 2837;
		level : USINT := 3;
	END_VAR
END_FUNCTION_BLOCK

{REDUND_ERROR} {REDUND_UNREPLICABLE} FUNCTION_BLOCK PMC_GetConfiguration (*Read the configuration file (as raw binary) from the PMC*) (*$GROUP=User,$CAT=User,$GROUPICON=User.png,$CATICON=User.png*)
	VAR_INPUT
		Execute : {REDUND_UNREPLICABLE} BOOL; (* Execution of the function block begins on a rising edge of this input.*)
	END_VAR
	VAR_OUTPUT
		Done : {REDUND_UNREPLICABLE} BOOL; (* Execution successful. Function block is finished*)
		Busy : {REDUND_UNREPLICABLE} BOOL; (* Function block is active and must continue to be called.*)
		Aborted : {REDUND_UNREPLICABLE} BOOL; (* Command aborted by another command*)
		Error : {REDUND_UNREPLICABLE} BOOL; (* Error occurred during execution.*)
		ErrorID : {REDUND_UNREPLICABLE} UINT; (* Error number*)
		nBytes : {REDUND_UNREPLICABLE} DINT; (* Number of bytes in the read configuration file*)
		Bytes : {REDUND_UNREPLICABLE} ARRAY[0..500000] OF USINT; (* the configuration file as a raw binary*)
	END_VAR
	VAR_IN_OUT
		PM_Controller : PMControllerType; (*Tracks state of the entire PMC system*)
	END_VAR
	VAR
		PMCFuncInfo : {REDUND_UNREPLICABLE} PMCFuncInfoType;
		timeout : {REDUND_UNREPLICABLE} UINT;
		totalByteNum : {REDUND_UNREPLICABLE} DINT;
		numFrames : {REDUND_UNREPLICABLE} DINT;
		cmdHB : {REDUND_UNREPLICABLE} INT;
		xIndex : {REDUND_UNREPLICABLE} DINT;
		beginning_index : {REDUND_UNREPLICABLE} DINT;
		numBytesToRead : {REDUND_UNREPLICABLE} SINT;
		DummyDone : {REDUND_UNREPLICABLE} BOOL;
	END_VAR
	VAR CONSTANT
		cmdID : UINT := 65293;
		maxNBytePerFrame : SINT := 39;
	END_VAR
END_FUNCTION_BLOCK

{REDUND_ERROR} {REDUND_UNREPLICABLE} FUNCTION_BLOCK PMC_GetFlywayTemp (*Get temperatures and power consumption of a flyway*) (*$GROUP=User,$CAT=User,$GROUPICON=User.png,$CATICON=User.png*)
	VAR_INPUT
		Execute : {REDUND_UNREPLICABLE} BOOL; (* Execution of the function block begins on a rising edge of this input.*)
		FlwID : {REDUND_UNREPLICABLE} USINT; (* Flyway ID*)
	END_VAR
	VAR_OUTPUT
		Valid : {REDUND_UNREPLICABLE} BOOL; (* The function block's output values can be used.*)
		Busy : {REDUND_UNREPLICABLE} BOOL; (* Function block is active and must continue to be called.*)
		Aborted : {REDUND_UNREPLICABLE} BOOL; (* Command aborted by another command*)
		Error : {REDUND_UNREPLICABLE} BOOL; (* Error occurred during execution.*)
		ErrorID : {REDUND_UNREPLICABLE} UINT; (* Error number*)
		Power : {REDUND_UNREPLICABLE} REAL; (* Flyway power consumption in watts*)
		CPUTemp : {REDUND_UNREPLICABLE} REAL; (* Flyway CPU temperature in degrees Celsius*)
		PATemp : {REDUND_UNREPLICABLE} REAL; (* Power amplifier temperature in degrees Celsius*)
		MTemp : {REDUND_UNREPLICABLE} REAL; (* Motor temperature in degrees Celsius*)
	END_VAR
	VAR_IN_OUT
		PM_Controller : PMControllerType; (*Tracks state of the entire PMC system*)
	END_VAR
	VAR
		PMCFuncInfo : {REDUND_UNREPLICABLE} PMCFuncInfoType;
		timeout : {REDUND_UNREPLICABLE} UINT;
		cmdHB : {REDUND_UNREPLICABLE} INT;
		nTemp : {REDUND_UNREPLICABLE} DWORD;
		intTemp : {REDUND_UNREPLICABLE} USINT;
		DummyDone : {REDUND_UNREPLICABLE} BOOL;
	END_VAR
	VAR CONSTANT
		cmdID : UINT := 2582;
	END_VAR
END_FUNCTION_BLOCK

{REDUND_ERROR} {REDUND_UNREPLICABLE} FUNCTION_BLOCK PMC_GetGroupStatus (*Get status of a xbot group *) (*$GROUP=User,$CAT=User,$GROUPICON=User.png,$CATICON=User.png*)
	VAR_INPUT
		Execute : {REDUND_UNREPLICABLE} BOOL; (* Execution of the function block begins on a rising edge of this input.*)
		GroupID : {REDUND_UNREPLICABLE} USINT; (* 0: delete all groups; >0: delete specific group*)
	END_VAR
	VAR_OUTPUT
		Done : {REDUND_UNREPLICABLE} BOOL; (* Execution successful. Function block is finished*)
		Busy : {REDUND_UNREPLICABLE} BOOL; (* Function block is active and must continue to be called.*)
		Aborted : {REDUND_UNREPLICABLE} BOOL; (* Command aborted by another command*)
		Error : {REDUND_UNREPLICABLE} BOOL; (* Error occurred during execution.*)
		ErrorID : {REDUND_UNREPLICABLE} UINT; (* Error number*)
		State : {REDUND_UNREPLICABLE} USINT; (* 0: unbonded 1:bonded*)
		nXbots : {REDUND_UNREPLICABLE} USINT; (* number of xbots in the group*)
		XbotID : {REDUND_UNREPLICABLE} ARRAY[0..31] OF USINT; (* xbot ID#s of the xbots in the group*)
	END_VAR
	VAR_IN_OUT
		PM_Controller : PMControllerType; (*Tracks state of the entire PMC system*)
	END_VAR
	VAR
		PMCFuncInfo : {REDUND_UNREPLICABLE} PMCFuncInfoType;
		timeout : {REDUND_UNREPLICABLE} UINT;
		cmdHB : {REDUND_UNREPLICABLE} INT;
		xbotNum : {REDUND_UNREPLICABLE} USINT;
		xIndex : {REDUND_UNREPLICABLE} SINT;
		DummyDone : {REDUND_UNREPLICABLE} BOOL;
	END_VAR
	VAR CONSTANT
		cmdID : UINT := 2838;
		maxNXbot : SINT := 32;
		Level : USINT := 6;
	END_VAR
END_FUNCTION_BLOCK

{REDUND_ERROR} {REDUND_UNREPLICABLE} FUNCTION_BLOCK PMC_GetMacroStatus (*get status of a macro *) (*$GROUP=User,$CAT=User,$GROUPICON=User.png,$CATICON=User.png*)
	VAR_INPUT
		Execute : {REDUND_UNREPLICABLE} BOOL; (* Execution of the function block begins on a rising edge of this input.*)
		MacroID : {REDUND_UNREPLICABLE} USINT; (* Macro ID#*)
	END_VAR
	VAR_OUTPUT
		Done : {REDUND_UNREPLICABLE} BOOL; (* Execution successful. Function block is finished*)
		Busy : {REDUND_UNREPLICABLE} BOOL; (* Function block is active and must continue to be called.*)
		Aborted : {REDUND_UNREPLICABLE} BOOL; (* Command aborted by another command*)
		Error : {REDUND_UNREPLICABLE} BOOL; (* Error occurred during execution.*)
		ErrorID : {REDUND_UNREPLICABLE} UINT; (* Error number*)
		State : {REDUND_UNREPLICABLE} USINT; (* 0: unsaved, 1: reserved, 2: saved*)
		nCmds : {REDUND_UNREPLICABLE} USINT; (* number of commands in the macro*)
	END_VAR
	VAR_IN_OUT
		PM_Controller : PMControllerType; (*Tracks state of the entire PMC system*)
	END_VAR
	VAR
		PMCFuncInfo : {REDUND_UNREPLICABLE} PMCFuncInfoType;
		timeout : {REDUND_UNREPLICABLE} UINT;
		cmdHB : {REDUND_UNREPLICABLE} INT;
		DummyDone : {REDUND_UNREPLICABLE} BOOL;
	END_VAR
	VAR CONSTANT
		cmdID : UINT := 2839;
		Level : USINT := 4;
	END_VAR
END_FUNCTION_BLOCK

{REDUND_ERROR} {REDUND_UNREPLICABLE} FUNCTION_BLOCK PMC_GetPayload (*Get payload of a xbot*) (*$GROUP=User,$CAT=User,$GROUPICON=User.png,$CATICON=User.png*)
	VAR_INPUT
		Execute : {REDUND_UNREPLICABLE} BOOL; (* Execution of the function block begins on a rising edge of this input.*)
		XbotID : {REDUND_UNREPLICABLE} USINT; (* Xbot ID# (>0)*)
	END_VAR
	VAR_OUTPUT
		Valid : {REDUND_UNREPLICABLE} BOOL; (* The function block's output values can be used.*)
		Busy : {REDUND_UNREPLICABLE} BOOL; (* Function block is active and must continue to be called.*)
		Aborted : {REDUND_UNREPLICABLE} BOOL; (* Command aborted by another command*)
		Error : {REDUND_UNREPLICABLE} BOOL; (* Error occurred during execution.*)
		ErrorID : {REDUND_UNREPLICABLE} UINT; (* Error number*)
		Payload : {REDUND_UNREPLICABLE} REAL; (* xbot payload in kilograms*)
	END_VAR
	VAR_IN_OUT
		PM_Controller : PMControllerType; (*Tracks state of the entire PMC system*)
	END_VAR
	VAR
		PMCFuncInfo : {REDUND_UNREPLICABLE} PMCFuncInfoType;
		timeout : {REDUND_UNREPLICABLE} UINT;
		cmdHB : {REDUND_UNREPLICABLE} INT;
		nTemp : {REDUND_UNREPLICABLE} DWORD;
		DummyDone : {REDUND_UNREPLICABLE} BOOL;
	END_VAR
	VAR CONSTANT
		cmdID : UINT := 2848;
	END_VAR
END_FUNCTION_BLOCK

{REDUND_ERROR} {REDUND_UNREPLICABLE} FUNCTION_BLOCK PMC_GetPMCErrorCode (*Retreive the latest PMC error codes*) (*$GROUP=User,$CAT=User,$GROUPICON=User.png,$CATICON=User.png*)
	VAR_INPUT
		Execute : {REDUND_UNREPLICABLE} BOOL; (* Execution of the function block begins on a rising edge of this input.*)
	END_VAR
	VAR_OUTPUT
		Valid : {REDUND_UNREPLICABLE} BOOL; (* The function block's output values can be used.*)
		Busy : {REDUND_UNREPLICABLE} BOOL; (* Function block is active and must continue to be called.*)
		Aborted : {REDUND_UNREPLICABLE} BOOL; (* Command aborted by another command*)
		Error : {REDUND_UNREPLICABLE} BOOL; (* Error occurred during execution.*)
		ErrorID : {REDUND_UNREPLICABLE} UINT; (* Error number*)
		NumErrors : {REDUND_UNREPLICABLE} USINT; (* Number of error codes read *)
		ErrorCodes : {REDUND_UNREPLICABLE} ARRAY[0..8] OF DINT; (* The read error codes*)
	END_VAR
	VAR_IN_OUT
		PM_Controller : PMControllerType; (*Tracks state of the entire PMC system*)
	END_VAR
	VAR
		PMCFuncInfo : {REDUND_UNREPLICABLE} PMCFuncInfoType;
		timeout : {REDUND_UNREPLICABLE} UINT;
		cmdHB : {REDUND_UNREPLICABLE} INT;
		eIndex : {REDUND_UNREPLICABLE} INT;
		DummyDone : {REDUND_UNREPLICABLE} BOOL;
	END_VAR
	VAR CONSTANT
		cmdID : UINT := 2573;
		maxErrors : SINT := 9;
	END_VAR
END_FUNCTION_BLOCK

{REDUND_ERROR} {REDUND_UNREPLICABLE} FUNCTION_BLOCK PMC_GetPmcStatus (*Get status of the Planar Motor Controller  *) (*$GROUP=User,$CAT=User,$GROUPICON=User.png,$CATICON=User.png*)
	VAR_INPUT
		Execute : {REDUND_UNREPLICABLE} BOOL; (* Execution of the function block begins on a rising edge of this input.*)
	END_VAR
	VAR_OUTPUT
		Valid : {REDUND_UNREPLICABLE} BOOL; (* The function block's output values can be used.*)
		Busy : {REDUND_UNREPLICABLE} BOOL; (* Function block is active and must continue to be called.*)
		Aborted : {REDUND_UNREPLICABLE} BOOL; (* Command aborted by another command*)
		Error : {REDUND_UNREPLICABLE} BOOL; (* Error occurred during execution.*)
		ErrorID : {REDUND_UNREPLICABLE} UINT; (* Error number*)
		State : {REDUND_UNREPLICABLE} USINT; (* 0: booting; 1: inactive; 2: activating; 5: operation; 7: deactivating; 8: error handling; 9: error*)
		nXbots : {REDUND_UNREPLICABLE} UINT; (* number of XBots*)
		Power : {REDUND_UNREPLICABLE} REAL; (* system power consumption in Watts*)
		MaxCPUTemp : {REDUND_UNREPLICABLE} REAL; (* highest cpu temperature in the system in degrees Celsius*)
		MaxPATemp : {REDUND_UNREPLICABLE} REAL; (* highest amplifier temperature in the system in degrees Celsius*)
		MaxMTemp : {REDUND_UNREPLICABLE} REAL; (* highest motor temperature in the system in degrees Celsius*)
	END_VAR
	VAR_IN_OUT
		PM_Controller : PMControllerType; (*Tracks state of the entire PMC system*)
	END_VAR
	VAR
		PMCFuncInfo : {REDUND_UNREPLICABLE} PMCFuncInfoType;
		timeout : {REDUND_UNREPLICABLE} UINT;
		cmdHB : {REDUND_UNREPLICABLE} INT;
		nTemp : {REDUND_UNREPLICABLE} DWORD;
		mTemp : {REDUND_UNREPLICABLE} BYTE;
		DummyDone : {REDUND_UNREPLICABLE} BOOL;
	END_VAR
	VAR CONSTANT
		cmdID : UINT := 2565;
	END_VAR
END_FUNCTION_BLOCK

{REDUND_ERROR} {REDUND_UNREPLICABLE} FUNCTION_BLOCK PMC_GetXbotProperty (*Get properties of a xbot*) (*$GROUP=User,$CAT=User,$GROUPICON=User.png,$CATICON=User.png*)
	VAR_INPUT
		Execute : {REDUND_UNREPLICABLE} BOOL; (* Execution of the function block begins on a rising edge of this input.*)
		XbotID : {REDUND_UNREPLICABLE} USINT; (* xbot ID# (>0)*)
	END_VAR
	VAR_OUTPUT
		Valid : {REDUND_UNREPLICABLE} BOOL; (* The function block's output values can be used.*)
		Busy : {REDUND_UNREPLICABLE} BOOL; (* Function block is active and must continue to be called.*)
		Aborted : {REDUND_UNREPLICABLE} BOOL; (* Command aborted by another command*)
		Error : {REDUND_UNREPLICABLE} BOOL; (* Error occurred during execution.*)
		ErrorID : {REDUND_UNREPLICABLE} UINT; (* Error number*)
		MoverType : {REDUND_UNREPLICABLE} USINT; (* xbot type*)
		PayloadW : {REDUND_UNREPLICABLE} REAL; (* payload weight in kilograms*)
		PayloadCG : {REDUND_UNREPLICABLE} REAL; (* payload center of gravity in meters*)
		XDim : {REDUND_UNREPLICABLE} REAL; (* mover X dimension in meters*)
		YDim : {REDUND_UNREPLICABLE} REAL; (* mover Y dimension in meters*)
		accLimit : {REDUND_UNREPLICABLE} REAL; (* acceleration limit in meters/second^2*)
	END_VAR
	VAR_IN_OUT
		PM_Controller : PMControllerType; (*Tracks state of the entire PMC system*)
	END_VAR
	VAR
		PMCFuncInfo : {REDUND_UNREPLICABLE} PMCFuncInfoType;
		timeout : {REDUND_UNREPLICABLE} UINT;
		cmdHB : {REDUND_UNREPLICABLE} INT;
		nTemp : {REDUND_UNREPLICABLE} DWORD;
		DummyDone : {REDUND_UNREPLICABLE} BOOL;
	END_VAR
	VAR CONSTANT
		cmdID : UINT := 2846;
	END_VAR
END_FUNCTION_BLOCK

{REDUND_ERROR} {REDUND_UNREPLICABLE} FUNCTION_BLOCK PMC_GetXbotStatus (*Get status of a xbot*) (*$GROUP=User,$CAT=User,$GROUPICON=User.png,$CATICON=User.png*)
	VAR_INPUT
		Execute : {REDUND_UNREPLICABLE} BOOL; (* Execution of the function block begins on a rising edge of this input.*)
		XbotID : {REDUND_UNREPLICABLE} USINT; (* xbot ID# (>0)*)
		FeedbackType : {REDUND_UNREPLICABLE} USINT; (* 0: Feedback Position 1: Feedback Force*)
	END_VAR
	VAR_OUTPUT
		Valid : {REDUND_UNREPLICABLE} BOOL; (* The function block's output values can be used.*)
		Busy : {REDUND_UNREPLICABLE} BOOL; (* Function block is active and must continue to be called.*)
		Aborted : {REDUND_UNREPLICABLE} BOOL; (* Command aborted by another command*)
		Error : {REDUND_UNREPLICABLE} BOOL; (* Error occurred during execution.*)
		ErrorID : {REDUND_UNREPLICABLE} UINT; (* Error number*)
		State : {REDUND_UNREPLICABLE} USINT; (* xbot state; 0: undetected; 1: discovering; 2: landed; 3: idling; 4: disabled; 5: motion; 6: waiting; 7: stopping; 8: obstacle; 9: hold; 10: stopped; 14: error;*)
		CmdLb : {REDUND_UNREPLICABLE} UINT; (* Command Label@Motion State*)
		FMState : {REDUND_UNREPLICABLE} USINT; (* 0: Not Force Mode;1: X force mode;2: Y force mode;4: Z force mode;3: XY force mode*)
		StarXID : {REDUND_UNREPLICABLE} USINT; (* 0: Not linked to any xbot; >0: start Xbot ID*)
		GroupID : {REDUND_UNREPLICABLE} USINT; (* 0: Not bond to any group; >0: group ID*)
		nCmds : {REDUND_UNREPLICABLE} UINT; (* number of commands in motion buffer*)
		IsBlocked : {REDUND_UNREPLICABLE} BOOL; (* is the xbot buffer blocked*)
		IsPaused : {REDUND_UNREPLICABLE} BOOL; (* is the xbot motion paused*)
		PosX : {REDUND_UNREPLICABLE} REAL; (* xbot X position in meters, force in Newtons*)
		PosY : {REDUND_UNREPLICABLE} REAL; (* xbot Y position in meters, force in Newtons*)
		PosZ : {REDUND_UNREPLICABLE} REAL; (* xbot Z position in meters, force in Newtons*)
		PosRx : {REDUND_UNREPLICABLE} REAL; (* xbot rotation about the X axis in radians, torque in Newton*Meters *)
		PosRy : {REDUND_UNREPLICABLE} REAL; (* xbot rotation about the Y axis in radians, torque in Newton*Meters*)
		PosRz : {REDUND_UNREPLICABLE} REAL; (* xbot rotation about the Z axis in radians, torque in Newton*Meters*)
		StereotypeID : {REDUND_UNREPLICABLE} USINT; (* XBot stereotype ID*)
	END_VAR
	VAR_IN_OUT
		PM_Controller : PMControllerType; (*Tracks state of the entire PMC system*)
	END_VAR
	VAR
		PMCFuncInfo : {REDUND_UNREPLICABLE} PMCFuncInfoType;
		timeout : {REDUND_UNREPLICABLE} UINT;
		cmdHB : {REDUND_UNREPLICABLE} INT;
		nTemp : {REDUND_UNREPLICABLE} DWORD;
		bTemp : {REDUND_UNREPLICABLE} BYTE;
		DummyDone : {REDUND_UNREPLICABLE} BOOL;
	END_VAR
	VAR CONSTANT
		cmdID : UINT := 2831;
	END_VAR
END_FUNCTION_BLOCK

{REDUND_ERROR} {REDUND_UNREPLICABLE} FUNCTION_BLOCK PMC_HoldForPMCState (*Waits until PMC reaches a given state*) (*$GROUP=User,$CAT=User,$GROUPICON=User.png,$CATICON=User.png*)
	VAR_INPUT
		Execute : {REDUND_UNREPLICABLE} BOOL; (* Execution of the function block begins on a rising edge of this input.*)
		State : {REDUND_UNREPLICABLE} USINT; (* PMC state to wait for 0: booting; 1: inactive; 2: activating; 5: operation; 7: deactivating; 8: error handling; 9: error*)
	END_VAR
	VAR_OUTPUT
		Done : {REDUND_UNREPLICABLE} BOOL := FALSE; (* has the PMC reached the state yet*)
		Busy : {REDUND_UNREPLICABLE} BOOL; (*if the function block is actively checking for PMC state*)
		Error : {REDUND_UNREPLICABLE} BOOL; (*error has occured*)
	END_VAR
	VAR_IN_OUT
		PM_Controller : PMControllerType; (*Tracks state of the entire PMC system*)
	END_VAR
	VAR
		PMC_ReadPMCState_db : {REDUND_UNREPLICABLE} PMC_ReadPmcState;
		CmdSta : {REDUND_UNREPLICABLE} INT := 0;
	END_VAR
END_FUNCTION_BLOCK

{REDUND_ERROR} {REDUND_UNREPLICABLE} FUNCTION_BLOCK PMC_HoldForXbotIdle (*Waits until the xbot is in idle state*) (*$GROUP=User,$CAT=User,$GROUPICON=User.png,$CATICON=User.png*)
	VAR_INPUT
		Execute : {REDUND_UNREPLICABLE} BOOL; (* Execution of the function block begins on a rising edge of this input.*)
		XbotID : {REDUND_UNREPLICABLE} USINT; (*xbot to wait for*)
	END_VAR
	VAR_OUTPUT
		Done : {REDUND_UNREPLICABLE} BOOL := FALSE; (* has the xbot reached the idle state yet*)
		Busy : {REDUND_UNREPLICABLE} BOOL; (*if the function block is actively checking for Xbots Idle*)
		Error : {REDUND_UNREPLICABLE} BOOL; (*error means invalid Xbot ID specified	*)
	END_VAR
	VAR_IN_OUT
		PM_Controller : PMControllerType; (*Tracks state of the entire PMC system*)
	END_VAR
	VAR
		PMC_ReadXbotState_db : {REDUND_UNREPLICABLE} PMC_ReadXbotState;
		CmdSta : {REDUND_UNREPLICABLE} INT := 0;
	END_VAR
END_FUNCTION_BLOCK

{REDUND_ERROR} {REDUND_UNREPLICABLE} FUNCTION_BLOCK PMC_HoldForXbotsIdle (*Waits until all chosen xbots are in idle state*) (*$GROUP=User,$CAT=User,$GROUPICON=User.png,$CATICON=User.png*)
	VAR_INPUT
		Execute : {REDUND_UNREPLICABLE} BOOL; (* Execution of the function block begins on a rising edge of this input.*)
		nXbots : {REDUND_UNREPLICABLE} USINT; (* number of xbots to wait for *)
		XbotID : {REDUND_UNREPLICABLE} ARRAY[0..77] OF USINT; (* xbots to wait for	*)
	END_VAR
	VAR_OUTPUT
		Done : {REDUND_UNREPLICABLE} BOOL := FALSE; (* has the xbot reached the idle state yet*)
		Busy : {REDUND_UNREPLICABLE} BOOL; (*if the function block is actively checking for Xbots Idle*)
		Error : {REDUND_UNREPLICABLE} BOOL; (*error means invalid Xbot ID specified	*)
	END_VAR
	VAR_IN_OUT
		PM_Controller : PMControllerType; (*Tracks state of the entire PMC system*)
	END_VAR
	VAR
		PMC_ReadXbotState_db : {REDUND_UNREPLICABLE} PMC_ReadXbotState;
		CmdSta : {REDUND_UNREPLICABLE} INT := 0;
		scan_all_xbots : {REDUND_UNREPLICABLE} BOOL;
		all_xbots_reached_state : {REDUND_UNREPLICABLE} BOOL;
		index : {REDUND_UNREPLICABLE} INT;
	END_VAR
END_FUNCTION_BLOCK

{REDUND_ERROR} {REDUND_UNREPLICABLE} FUNCTION_BLOCK PMC_HoldForXbotsState (*Waits until all chosen xbots are in given states*) (*$GROUP=User,$CAT=User,$GROUPICON=User.png,$CATICON=User.png*)
	VAR_INPUT
		Execute : {REDUND_UNREPLICABLE} BOOL; (* Execution of the function block begins on a rising edge of this input.*)
		nXbots : {REDUND_UNREPLICABLE} USINT; (* number of xbots to wait for *)
		XbotID : {REDUND_UNREPLICABLE} ARRAY[0..77] OF USINT; (* xbots to wait for	*)
		States : {REDUND_UNREPLICABLE} ARRAY[0..77] OF USINT; (* states to wait for 0 = undetected, 1 = discovering, 2 = landed, 3 = idle, 4 = disabled, 5 = in motion, 6 = waiting, 7 = stopping, 8 = obstacle, 9 = hold, 10 = stopped, 14 = error*)
	END_VAR
	VAR_OUTPUT
		Done : {REDUND_UNREPLICABLE} BOOL := FALSE; (* has the xbot reached the idle state yet*)
		Busy : {REDUND_UNREPLICABLE} BOOL; (*if the function block is actively checking for Xbots Idle*)
		Error : {REDUND_UNREPLICABLE} BOOL; (*error means invalid Xbot ID specified	*)
	END_VAR
	VAR_IN_OUT
		PM_Controller : PMControllerType; (*Tracks state of the entire PMC system*)
	END_VAR
	VAR
		PMC_ReadXbotState_db : {REDUND_UNREPLICABLE} PMC_ReadXbotState;
		CmdSta : {REDUND_UNREPLICABLE} INT := 0;
		scan_all_xbots : {REDUND_UNREPLICABLE} BOOL;
		all_xbots_reached_state : {REDUND_UNREPLICABLE} BOOL;
		index : {REDUND_UNREPLICABLE} INT;
	END_VAR
END_FUNCTION_BLOCK

{REDUND_ERROR} {REDUND_UNREPLICABLE} FUNCTION_BLOCK PMC_HoldForXbotState (*Waits until the xbot are in the given state*) (*$GROUP=User,$CAT=User,$GROUPICON=User.png,$CATICON=User.png*)
	VAR_INPUT
		Execute : {REDUND_UNREPLICABLE} BOOL; (* Execution of the function block begins on a rising edge of this input.*)
		XbotID : {REDUND_UNREPLICABLE} USINT; (*xbot to wait for*)
		State : {REDUND_UNREPLICABLE} USINT; (* state to wait for 0 = undetected, 1 = discovering, 2 = landed, 3 = idle, 4 = disabled, 5 = in motion, 6 = waiting, 7 = stopping, 8 = obstacle, 9 = hold, 10 = stopped, 14 = error*)
	END_VAR
	VAR_OUTPUT
		Done : {REDUND_UNREPLICABLE} BOOL := FALSE; (* has the xbot reached the state state yet*)
		Busy : {REDUND_UNREPLICABLE} BOOL; (*if the function block is actively checking for Xbots Idle*)
		Error : {REDUND_UNREPLICABLE} BOOL; (*error means invalid Xbot ID specified	*)
	END_VAR
	VAR_IN_OUT
		PM_Controller : PMControllerType; (*Tracks state of the entire PMC system*)
	END_VAR
	VAR
		PMC_ReadXbotState_db : {REDUND_UNREPLICABLE} PMC_ReadXbotState;
		CmdSta : {REDUND_UNREPLICABLE} INT := 0;
	END_VAR
END_FUNCTION_BLOCK

{REDUND_ERROR} {REDUND_UNREPLICABLE} FUNCTION_BLOCK PMC_JogVelocity (*jog a xbot *) (*$GROUP=User,$CAT=User,$GROUPICON=User.png,$CATICON=User.png*)
	VAR_INPUT
		Execute : {REDUND_UNREPLICABLE} BOOL; (* Execution of the function block begins on a rising edge of this input.*)
		XbotID : {REDUND_UNREPLICABLE} USINT; (* xbot ID# (>0)*)
		Enable : {REDUND_UNREPLICABLE} BOOL; (* 0: stop jogging xbot; 1: start jogging xbot*)
		Direction : {REDUND_UNREPLICABLE} REAL; (* direction to jog in radians*)
		Velocity : {REDUND_UNREPLICABLE} REAL; (* jogging speed in meters/second*)
	END_VAR
	VAR_OUTPUT
		Done : {REDUND_UNREPLICABLE} BOOL; (* Execution successful. Function block is finished*)
		Busy : {REDUND_UNREPLICABLE} BOOL; (* Function block is active and must continue to be called.*)
		Aborted : {REDUND_UNREPLICABLE} BOOL; (* Command aborted by another command*)
		Error : {REDUND_UNREPLICABLE} BOOL; (* Error occurred during execution.*)
		ErrorID : {REDUND_UNREPLICABLE} UINT; (* Error number*)
	END_VAR
	VAR_IN_OUT
		PM_Controller : PMControllerType; (*Tracks state of the entire PMC system*)
	END_VAR
	VAR
		PMCFuncInfo : {REDUND_UNREPLICABLE} PMCFuncInfoType;
		timeout : {REDUND_UNREPLICABLE} UINT;
		cmdHB : {REDUND_UNREPLICABLE} INT;
		DummyDone : {REDUND_UNREPLICABLE} BOOL;
	END_VAR
	VAR CONSTANT
		cmdID : UINT := 2842;
	END_VAR
END_FUNCTION_BLOCK

{REDUND_ERROR} FUNCTION_BLOCK PMC_LevitationCtrl (*Levitate/Land a xbot*) (*$GROUP=User,$CAT=User,$GROUPICON=User.png,$CATICON=User.png*)
	VAR_INPUT
		Execute : {REDUND_UNREPLICABLE} BOOL; (* Execution of the function block begins on a rising edge of this input.*)
		XbotID : {REDUND_UNREPLICABLE} USINT; (* 0: leviate/land all xbots; >0: leviate/land specific xbot*)
		Level : {REDUND_UNREPLICABLE} USINT; (* 0 = landed, 1 = levitate*)
	END_VAR
	VAR_OUTPUT
		Ack : {REDUND_UNREPLICABLE} BOOL; (* Command has been received by PMC, any returned values can be used*)
		Done : {REDUND_UNREPLICABLE} BOOL; (* Xbot(s) have finished leviating/landing*)
		Busy : {REDUND_UNREPLICABLE} BOOL; (* Function block is active and must continue to be called.*)
		Aborted : {REDUND_UNREPLICABLE} BOOL; (* Command aborted by another command*)
		Error : {REDUND_UNREPLICABLE} BOOL; (* Error occurred during execution.*)
		ErrorID : {REDUND_UNREPLICABLE} UINT; (* Error number*)
	END_VAR
	VAR_IN_OUT
		PM_Controller : PMControllerType; (*Tracks state of the entire PMC system*)
	END_VAR
	VAR
		PMCFuncInfo : {REDUND_UNREPLICABLE} PMCFuncInfoType;
		timeout : {REDUND_UNREPLICABLE} UINT;
		cmdHB : {REDUND_UNREPLICABLE} INT;
		requestEventID : BOOL;
	END_VAR
	VAR CONSTANT
		cmdID : UINT := 2829;
	END_VAR
END_FUNCTION_BLOCK

{REDUND_ERROR} {REDUND_UNREPLICABLE} FUNCTION_BLOCK PMC_MotionBufferCtrl (*Control a xbots motion buffer*) (*$GROUP=User,$CAT=User,$GROUPICON=User.png,$CATICON=User.png*)
	VAR_INPUT
		Execute : {REDUND_UNREPLICABLE} BOOL; (* Execution of the function block begins on a rising edge of this input.*)
		Level : {REDUND_UNREPLICABLE} USINT; (* 0: Block buffer;1: release buffer;2: clear buffer*)
		XbotID : {REDUND_UNREPLICABLE} USINT; (* 0: control all xbot buffers; >0: control specific xbot buffer*)
	END_VAR
	VAR_OUTPUT
		Done : {REDUND_UNREPLICABLE} BOOL; (* Execution successful. Function block is finished*)
		Busy : {REDUND_UNREPLICABLE} BOOL; (* Function block is active and must continue to be called.*)
		Aborted : {REDUND_UNREPLICABLE} BOOL; (* Command aborted by another command*)
		Error : {REDUND_UNREPLICABLE} BOOL; (* Error occurred during execution.*)
		ErrorID : {REDUND_UNREPLICABLE} UINT; (* Error number*)
	END_VAR
	VAR_IN_OUT
		PM_Controller : PMControllerType; (*Tracks state of the entire PMC system*)
	END_VAR
	VAR
		PMCFuncInfo : {REDUND_UNREPLICABLE} PMCFuncInfoType;
		timeout : {REDUND_UNREPLICABLE} UINT;
		cmdHB : {REDUND_UNREPLICABLE} INT;
		DummyDone : {REDUND_UNREPLICABLE} BOOL;
	END_VAR
	VAR CONSTANT
		cmdID : UINT := 2837;
	END_VAR
END_FUNCTION_BLOCK

{REDUND_ERROR} FUNCTION_BLOCK PMC_PauseXbots (*pause xbot motion*) (*$GROUP=User,$CAT=User,$GROUPICON=User.png,$CATICON=User.png*)
	VAR_INPUT
		Execute : {REDUND_UNREPLICABLE} BOOL; (* Execution of the function block begins on a rising edge of this input.*)
		XbotID : {REDUND_UNREPLICABLE} USINT; (* 0: all Xbots; >0: specific Xbot*)
	END_VAR
	VAR_OUTPUT
		Ack : {REDUND_UNREPLICABLE} BOOL; (* Command has been received by PMC, any returned values can be used*)
		Done : {REDUND_UNREPLICABLE} BOOL; (* Xbot(s) have paused motion*)
		Busy : {REDUND_UNREPLICABLE} BOOL; (* Function block is active and must continue to be called.*)
		Aborted : {REDUND_UNREPLICABLE} BOOL; (* Command aborted by another command*)
		Error : {REDUND_UNREPLICABLE} BOOL; (* Error occurred during execution.*)
		ErrorID : {REDUND_UNREPLICABLE} UINT; (* Error number*)
	END_VAR
	VAR_IN_OUT
		PM_Controller : PMControllerType; (*Tracks state of the entire PMC system*)
	END_VAR
	VAR
		PMCFuncInfo : {REDUND_UNREPLICABLE} PMCFuncInfoType;
		timeout : {REDUND_UNREPLICABLE} UINT;
		cmdHB : {REDUND_UNREPLICABLE} INT;
		requestEventID : BOOL;
	END_VAR
	VAR CONSTANT
		cmdID : UINT := 2849;
		Level : USINT := 1;
	END_VAR
END_FUNCTION_BLOCK

{REDUND_ERROR} {REDUND_UNREPLICABLE} FUNCTION_BLOCK PMC_PlanetMotionCtrl (*begin star-planet motion*) (*$GROUP=User,$CAT=User,$GROUPICON=User.png,$CATICON=User.png*)
	VAR_INPUT
		Execute : {REDUND_UNREPLICABLE} BOOL; (* Execution of the function block begins on a rising edge of this input.*)
		Level : {REDUND_UNREPLICABLE} USINT; (* 0:disconnect from star xbot;1: connect to star xbot*)
		StarXID : {REDUND_UNREPLICABLE} USINT; (* xbot ID# of the star xbot*)
		nXbots : {REDUND_UNREPLICABLE} USINT; (* number of planet xbots (up to 32)*)
		PlanetXID : {REDUND_UNREPLICABLE} ARRAY[0..31] OF USINT; (* planet xbot ID#s*)
	END_VAR
	VAR_OUTPUT
		Done : {REDUND_UNREPLICABLE} BOOL; (* Execution successful. Function block is finished*)
		Busy : {REDUND_UNREPLICABLE} BOOL; (* Function block is active and must continue to be called.*)
		Aborted : {REDUND_UNREPLICABLE} BOOL; (* Command aborted by another command*)
		Error : {REDUND_UNREPLICABLE} BOOL; (* Error occurred during execution.*)
		ErrorID : {REDUND_UNREPLICABLE} UINT; (* Error number*)
	END_VAR
	VAR_IN_OUT
		PM_Controller : PMControllerType; (*Tracks state of the entire PMC system*)
	END_VAR
	VAR
		PMCFuncInfo : {REDUND_UNREPLICABLE} PMCFuncInfoType;
		timeout : {REDUND_UNREPLICABLE} UINT;
		cmdHB : {REDUND_UNREPLICABLE} INT;
		xbotNum : {REDUND_UNREPLICABLE} USINT;
		xIndex : {REDUND_UNREPLICABLE} SINT;
		DummyDone : {REDUND_UNREPLICABLE} BOOL;
	END_VAR
	VAR CONSTANT
		cmdID : UINT := 2847;
		maxNXbot : SINT := 32;
	END_VAR
END_FUNCTION_BLOCK

{REDUND_ERROR} {REDUND_UNREPLICABLE} FUNCTION_BLOCK PMC_Queue_Create (*Creates a new queue*) (*$GROUP=User,$CAT=User,$GROUPICON=User.png,$CATICON=User.png*)
	VAR_INPUT
		Execute : {REDUND_UNREPLICABLE} BOOL; (* Execution of the function block begins on a rising edge of this input.	*)
		QueueID : {REDUND_UNREPLICABLE} USINT; (* queue ID: >0 *)
		EntryLocation : {REDUND_UNREPLICABLE} USINT; (* 0: bottom left, 1: top left, 2: top right, 3: bottom right*)
		ExitLocation : {REDUND_UNREPLICABLE} USINT; (* 0: bottom left, 1: top left, 2: top right, 3: bottom right*)
		BottomLeftX : {REDUND_UNREPLICABLE} REAL; (* X coordinate of bottom left corner of queue (m)*)
		BottomLeftY : {REDUND_UNREPLICABLE} REAL; (* Y coordinate of bottom left corner of queue (m)*)
		TopRightX : {REDUND_UNREPLICABLE} REAL; (* X coordinate of right top corner of queue (m)*)
		TopRightY : {REDUND_UNREPLICABLE} REAL; (* Y coordinate of right top corner of queue (m)*)
		MaxXbotSizeX : {REDUND_UNREPLICABLE} REAL; (* max mover size in X (m)*)
		MaxXbotSizeY : {REDUND_UNREPLICABLE} REAL; (* max mover size in Y (m)*)
		MaxVel : {REDUND_UNREPLICABLE} REAL; (* max travilling speed inside the zone (m/s)*)
		MaxAcc : {REDUND_UNREPLICABLE} REAL; (* max travelling acceleration inside the zone (m/s^s)*)
	END_VAR
	VAR_OUTPUT
		Done : {REDUND_UNREPLICABLE} BOOL; (* Execution successful. Function block is finished*)
		Busy : {REDUND_UNREPLICABLE} BOOL; (* Function block is active and must continue to be called.*)
		Aborted : {REDUND_UNREPLICABLE} BOOL; (* Command aborted by another command*)
		Error : {REDUND_UNREPLICABLE} BOOL; (* Error occurred during execution.*)
		ErrorID : {REDUND_UNREPLICABLE} UINT; (* Error number*)
	END_VAR
	VAR_IN_OUT
		PM_Controller : PMControllerType; (*Tracks state of the entire PMC system*)
	END_VAR
	VAR
		PMCFuncInfo : {REDUND_UNREPLICABLE} PMCFuncInfoType;
		timeout : {REDUND_UNREPLICABLE} UINT;
		cmdHB : {REDUND_UNREPLICABLE} INT;
		nTemp : {REDUND_UNREPLICABLE} DWORD;
		DummyDone : {REDUND_UNREPLICABLE} BOOL;
	END_VAR
	VAR CONSTANT
		Mode : USINT := 0; (* 0: create zone*)
		cmdID : UINT := 3072;
	END_VAR
END_FUNCTION_BLOCK

{REDUND_ERROR} {REDUND_UNREPLICABLE} FUNCTION_BLOCK PMC_Queue_Delete (*Deletes a queue *) (*$GROUP=User,$CAT=User,$GROUPICON=User.png,$CATICON=User.png*)
	VAR_INPUT
		Execute : {REDUND_UNREPLICABLE} BOOL; (* Execution of the function block begins on a rising edge of this input.	*)
		QueueID : {REDUND_UNREPLICABLE} USINT; (* queue ID:  0 - delete all queues, >0 - delete single queue*)
	END_VAR
	VAR_OUTPUT
		Done : {REDUND_UNREPLICABLE} BOOL; (* Execution successful. Function block is finished*)
		Busy : {REDUND_UNREPLICABLE} BOOL; (* Function block is active and must continue to be called.*)
		Aborted : {REDUND_UNREPLICABLE} BOOL; (* Command aborted by another command*)
		Error : {REDUND_UNREPLICABLE} BOOL; (* Error occurred during execution.*)
		ErrorID : {REDUND_UNREPLICABLE} UINT; (* Error number*)
	END_VAR
	VAR_IN_OUT
		PM_Controller : PMControllerType; (*Tracks state of the entire PMC system*)
	END_VAR
	VAR
		PMCFuncInfo : {REDUND_UNREPLICABLE} PMCFuncInfoType;
		timeout : {REDUND_UNREPLICABLE} UINT;
		cmdHB : {REDUND_UNREPLICABLE} INT;
		nTemp : {REDUND_UNREPLICABLE} DWORD;
		DummyDone : {REDUND_UNREPLICABLE} BOOL;
	END_VAR
	VAR CONSTANT
		Mode : USINT := 1; (* 1: delete zone*)
		cmdID : UINT := 3072;
	END_VAR
END_FUNCTION_BLOCK

{REDUND_ERROR} {REDUND_UNREPLICABLE} FUNCTION_BLOCK PMC_Queue_ExitClear (*Tells queue that xbot has been moved from the queue area*) (*$GROUP=User,$CAT=User,$GROUPICON=User.png,$CATICON=User.png*)
	VAR_INPUT
		Execute : {REDUND_UNREPLICABLE} BOOL; (* Execution of the function block begins on a rising edge of this input.	*)
		QueueID : {REDUND_UNREPLICABLE} USINT; (* queue ID: >0*)
	END_VAR
	VAR_OUTPUT
		Done : {REDUND_UNREPLICABLE} BOOL; (* Execution successful. Function block is finished*)
		Busy : {REDUND_UNREPLICABLE} BOOL; (* Function block is active and must continue to be called.*)
		Aborted : {REDUND_UNREPLICABLE} BOOL; (* Command aborted by another command*)
		Error : {REDUND_UNREPLICABLE} BOOL; (* Error occurred during execution.*)
		ErrorID : {REDUND_UNREPLICABLE} UINT; (* Error number*)
	END_VAR
	VAR_IN_OUT
		PM_Controller : PMControllerType; (*Tracks state of the entire PMC system*)
	END_VAR
	VAR
		PMCFuncInfo : {REDUND_UNREPLICABLE} PMCFuncInfoType;
		timeout : {REDUND_UNREPLICABLE} UINT;
		cmdHB : {REDUND_UNREPLICABLE} INT;
		nTemp : {REDUND_UNREPLICABLE} DWORD;
		DummyDone : {REDUND_UNREPLICABLE} BOOL;
	END_VAR
	VAR CONSTANT
		cmdID : UINT := 3074;
	END_VAR
END_FUNCTION_BLOCK

{REDUND_ERROR} {REDUND_UNREPLICABLE} FUNCTION_BLOCK PMC_Queue_GetQueueInfo (*Get the current info on the current xbots in a queue*) (*$GROUP=User,$CAT=User,$GROUPICON=User.png,$CATICON=User.png*)
	VAR_INPUT
		Execute : {REDUND_UNREPLICABLE} BOOL; (* Execution of the function block begins on a rising edge of this input.	*)
		QueueID : {REDUND_UNREPLICABLE} USINT; (* queue ID: >0*)
	END_VAR
	VAR_OUTPUT
		Done : {REDUND_UNREPLICABLE} BOOL; (* Execution successful. Function block is finished*)
		Busy : {REDUND_UNREPLICABLE} BOOL; (* Function block is active and must continue to be called.*)
		Aborted : {REDUND_UNREPLICABLE} BOOL; (* Command aborted by another command*)
		Error : {REDUND_UNREPLICABLE} BOOL; (* Error occurred during execution.*)
		ErrorID : {REDUND_UNREPLICABLE} UINT; (* Error number*)
		EntranceStatus : {REDUND_UNREPLICABLE} USINT; (*0: queue is not ready to receive new xbot, 1: queue is ready to receive new xbot*)
		ExitStatus : {REDUND_UNREPLICABLE} USINT; (*0: xbot is not ready to fetch, 1: xbot is ready to fetch*)
		QueueStatus : {REDUND_UNREPLICABLE} USINT; (*0: queue is available, 1: queue is full*)
		nXbots : {REDUND_UNREPLICABLE} USINT; (*number of xbots in the queue*)
		XbotIDs : {REDUND_UNREPLICABLE} ARRAY[0..37] OF USINT; (*the IDs of the xbots in queue in the FIFO order of the queue *)
	END_VAR
	VAR_IN_OUT
		PM_Controller : PMControllerType; (*Tracks state of the entire PMC system*)
	END_VAR
	VAR
		PMCFuncInfo : {REDUND_UNREPLICABLE} PMCFuncInfoType;
		timeout : {REDUND_UNREPLICABLE} UINT;
		cmdHB : {REDUND_UNREPLICABLE} INT;
		DummyDone : {REDUND_UNREPLICABLE} BOOL;
		temp : {REDUND_UNREPLICABLE} SINT;
		xIndex : {REDUND_UNREPLICABLE} SINT;
	END_VAR
	VAR CONSTANT
		cmdID : UINT := 3076;
	END_VAR
END_FUNCTION_BLOCK

{REDUND_ERROR} {REDUND_UNREPLICABLE} FUNCTION_BLOCK PMC_Queue_GetQueueStatus (*Get current status of a queue*) (*$GROUP=User,$CAT=User,$GROUPICON=User.png,$CATICON=User.png*)
	VAR_INPUT
		Execute : {REDUND_UNREPLICABLE} BOOL; (* Execution of the function block begins on a rising edge of this input.	*)
		QueueID : {REDUND_UNREPLICABLE} USINT; (* queue ID: >0*)
	END_VAR
	VAR_OUTPUT
		Done : {REDUND_UNREPLICABLE} BOOL; (* Execution successful. Function block is finished*)
		Busy : {REDUND_UNREPLICABLE} BOOL; (* Function block is active and must continue to be called.*)
		Aborted : {REDUND_UNREPLICABLE} BOOL; (* Command aborted by another command*)
		Error : {REDUND_UNREPLICABLE} BOOL; (* Error occurred during execution.*)
		ErrorID : {REDUND_UNREPLICABLE} UINT; (* Error number*)
		QueueState : {REDUND_UNREPLICABLE} USINT; (*0: not defined, 2: defined*)
		EntranceStatus : {REDUND_UNREPLICABLE} USINT; (*0: queue is not ready to receive new xbot, 1: queue is ready to receive new xbot*)
		EntranceX : {REDUND_UNREPLICABLE} REAL; (*X coordinate of entry (m)*)
		EntranceY : {REDUND_UNREPLICABLE} REAL; (* Y coordinate of entry (m)*)
		ExitStatus : {REDUND_UNREPLICABLE} USINT; (*0: xbot is not ready to fetch, 1: xbot is ready to fetch*)
		ExitXbotID : {REDUND_UNREPLICABLE} USINT; (*Xbot ID to fetch*)
	END_VAR
	VAR_IN_OUT
		PM_Controller : PMControllerType; (*Tracks state of the entire PMC system*)
	END_VAR
	VAR
		PMCFuncInfo : {REDUND_UNREPLICABLE} PMCFuncInfoType;
		timeout : {REDUND_UNREPLICABLE} UINT;
		cmdHB : {REDUND_UNREPLICABLE} INT;
		DummyDone : {REDUND_UNREPLICABLE} BOOL;
		temp : {REDUND_UNREPLICABLE} SINT;
		ntemp : {REDUND_UNREPLICABLE} DWORD;
	END_VAR
	VAR CONSTANT
		cmdID : UINT := 3075;
	END_VAR
END_FUNCTION_BLOCK

{REDUND_ERROR} {REDUND_UNREPLICABLE} FUNCTION_BLOCK PMC_Queue_HoldForEntranceReady (*Waits until the queue can accept a new xbot (returns immediantly if queue is not defined)*) (*$GROUP=User,$CAT=User,$GROUPICON=User.png,$CATICON=User.png*)
	VAR_INPUT
		Execute : {REDUND_UNREPLICABLE} BOOL; (* Execution of the function block begins on a rising edge of this input.	*)
		QueueID : {REDUND_UNREPLICABLE} USINT; (* queue ID: >0*)
	END_VAR
	VAR_OUTPUT
		Done : {REDUND_UNREPLICABLE} BOOL; (* Execution successful. Function block is finished*)
		Busy : {REDUND_UNREPLICABLE} BOOL; (* Function block is active and must continue to be called.*)
		Aborted : {REDUND_UNREPLICABLE} BOOL; (* Command aborted by another command*)
		Error : {REDUND_UNREPLICABLE} BOOL; (* Error occurred during execution.*)
		ErrorID : {REDUND_UNREPLICABLE} UINT; (* Error number*)
		QueueState : {REDUND_UNREPLICABLE} USINT; (*0: not defined, 2: defined*)
		EntranceStatus : {REDUND_UNREPLICABLE} USINT; (*0: queue is not ready to receive new xbot, 1: queue is ready to receive new xbot*)
		EntranceX : {REDUND_UNREPLICABLE} REAL; (*X coordinate of entry (m)*)
		EntranceY : {REDUND_UNREPLICABLE} REAL; (* Y coordinate of entry (m)*)
	END_VAR
	VAR_IN_OUT
		PM_Controller : PMControllerType; (*Tracks state of the entire PMC system*)
	END_VAR
	VAR
		CmdSta : {REDUND_UNREPLICABLE} INT := 0;
		PMC_Queue_GetQueueStatus_db : {REDUND_UNREPLICABLE} PMC_Queue_GetQueueStatus;
		entrance_is_ready_or_error : {REDUND_UNREPLICABLE} BOOL;
	END_VAR
END_FUNCTION_BLOCK

{REDUND_ERROR} {REDUND_UNREPLICABLE} FUNCTION_BLOCK PMC_Queue_HoldForExitReady (*Waits until the queue has a new xbot ready to exit (returns immediantly if queue is not defined)*) (*$GROUP=User,$CAT=User,$GROUPICON=User.png,$CATICON=User.png*)
	VAR_INPUT
		Execute : {REDUND_UNREPLICABLE} BOOL; (* Execution of the function block begins on a rising edge of this input.	*)
		QueueID : {REDUND_UNREPLICABLE} USINT; (* queue ID: >0*)
	END_VAR
	VAR_OUTPUT
		Done : {REDUND_UNREPLICABLE} BOOL; (* Execution successful. Function block is finished*)
		Busy : {REDUND_UNREPLICABLE} BOOL; (* Function block is active and must continue to be called.*)
		Aborted : {REDUND_UNREPLICABLE} BOOL; (* Command aborted by another command*)
		Error : {REDUND_UNREPLICABLE} BOOL; (* Error occurred during execution.*)
		ErrorID : {REDUND_UNREPLICABLE} UINT; (* Error number*)
		QueueState : {REDUND_UNREPLICABLE} USINT; (*0: not defined, 2: defined*)
		ExitStatus : {REDUND_UNREPLICABLE} USINT; (*0: xbot is not ready to fetch, 1: xbot is ready to fetch*)
		ExitXbotID : {REDUND_UNREPLICABLE} USINT; (*Xbot ID to fetch*)
	END_VAR
	VAR_IN_OUT
		PM_Controller : PMControllerType; (*Tracks state of the entire PMC system*)
	END_VAR
	VAR
		CmdSta : {REDUND_UNREPLICABLE} INT := 0;
		PMC_Queue_GetQueueStatus_db : {REDUND_UNREPLICABLE} PMC_Queue_GetQueueStatus;
		exit_is_ready_or_error : {REDUND_UNREPLICABLE} BOOL;
	END_VAR
END_FUNCTION_BLOCK

{REDUND_ERROR} {REDUND_UNREPLICABLE} FUNCTION_BLOCK PMC_Queue_SendXbotToQueue (*Sends a xbot to a queue*) (*$GROUP=User,$CAT=User,$GROUPICON=User.png,$CATICON=User.png*)
	VAR_INPUT
		Execute : {REDUND_UNREPLICABLE} BOOL; (* Execution of the function block begins on a rising edge of this input.	*)
		QueueID : {REDUND_UNREPLICABLE} USINT; (* queue ID: >0 *)
		XbotID : {REDUND_UNREPLICABLE} USINT; (* xbot ID: >0*)
	END_VAR
	VAR_OUTPUT
		Done : {REDUND_UNREPLICABLE} BOOL; (* Execution successful. Function block is finished*)
		Busy : {REDUND_UNREPLICABLE} BOOL; (* Function block is active and must continue to be called.*)
		Aborted : {REDUND_UNREPLICABLE} BOOL; (* Command aborted by another command*)
		Error : {REDUND_UNREPLICABLE} BOOL; (* Error occurred during execution.*)
		ErrorID : {REDUND_UNREPLICABLE} UINT; (* Error number*)
	END_VAR
	VAR_IN_OUT
		PM_Controller : PMControllerType; (*Tracks state of the entire PMC system*)
	END_VAR
	VAR
		PMCFuncInfo : {REDUND_UNREPLICABLE} PMCFuncInfoType;
		timeout : {REDUND_UNREPLICABLE} UINT;
		cmdHB : {REDUND_UNREPLICABLE} INT;
		nTemp : {REDUND_UNREPLICABLE} DWORD;
		DummyDone : {REDUND_UNREPLICABLE} BOOL;
	END_VAR
	VAR CONSTANT
		cmdID : UINT := 3073;
	END_VAR
END_FUNCTION_BLOCK

{REDUND_ERROR} {REDUND_UNREPLICABLE} FUNCTION_BLOCK PMC_ReadDigitalSignalFromPMC (*read status of the PMC digital outputs*) (*$GROUP=User,$CAT=User,$GROUPICON=User.png,$CATICON=User.png*)
	VAR_INPUT
		Enable : {REDUND_UNREPLICABLE} BOOL; (* Enable function block*)
		DiID : {REDUND_UNREPLICABLE} USINT; (* digital input (of the PLC fieldbus) number [1-128]*)
	END_VAR
	VAR_OUTPUT
		Valid : {REDUND_UNREPLICABLE} BOOL; (* function block successfully read the digital signal*)
		Level : {REDUND_UNREPLICABLE} BOOL; (* level of the digital signal*)
	END_VAR
	VAR_IN_OUT
		PM_Controller : PMControllerType; (*Tracks state of the entire PMC system*)
	END_VAR
	VAR
		ByteOffset : {REDUND_UNREPLICABLE} DINT;
		BitOffset : {REDUND_UNREPLICABLE} DINT;
		RegVal : {REDUND_UNREPLICABLE} USINT;
	END_VAR
END_FUNCTION_BLOCK

{REDUND_ERROR} {REDUND_UNREPLICABLE} FUNCTION_BLOCK PMC_ReadPmcState (*Read Planar Motor Controller state *) (*$GROUP=User,$CAT=User,$GROUPICON=User.png,$CATICON=User.png*)
	VAR_INPUT
		Enable : {REDUND_UNREPLICABLE} BOOL; (* enable function block*)
	END_VAR
	VAR_OUTPUT
		Valid : {REDUND_UNREPLICABLE} BOOL; (* successfully read PMC state*)
		State : {REDUND_UNREPLICABLE} USINT; (* 0: booting; 1: inactive; 2: activating; 5: operation; 7: deactivating; 8: error handling; 9: error*)
	END_VAR
	VAR_IN_OUT
		PM_Controller : PMControllerType; (*Tracks state of the entire PMC system*)
	END_VAR
END_FUNCTION_BLOCK

{REDUND_ERROR} {REDUND_UNREPLICABLE} FUNCTION_BLOCK PMC_ReadStreamFeedback (*read xbot stream feedback*) (*$GROUP=User,$CAT=User,$GROUPICON=User.png,$CATICON=User.png*)
	VAR_INPUT
		Enable : {REDUND_UNREPLICABLE} BOOL; (* enable function block*)
		StreamChannelID : {REDUND_UNREPLICABLE} USINT; (* stream channel ID#*)
		XBotAxisID : {REDUND_UNREPLICABLE} USINT; (* Axis ID. X=1, Y=2, Z=3, RX=4, RY=5, RZ=6*)
	END_VAR
	VAR_OUTPUT
		Valid : {REDUND_UNREPLICABLE} BOOL; (* successfully read xbot stream feedback*)
		FeedbackValue : {REDUND_UNREPLICABLE} REAL; (* value read from stream: meters/Newtons for X, Y, Z; radians/Newton*Meters for Rx, Ry, Rz*)
	END_VAR
	VAR_IN_OUT
		PM_Controller : PMControllerType; (*Tracks state of the entire PMC system*)
	END_VAR
	VAR
		AxisCount : {REDUND_UNREPLICABLE} USINT;
		ByteOffset : {REDUND_UNREPLICABLE} UINT;
		tempFBAxis : {REDUND_UNREPLICABLE} USINT;
		index : {REDUND_UNREPLICABLE} SINT;
		CurrentAxisOffset : {REDUND_UNREPLICABLE} USINT;
		RegVal : {REDUND_UNREPLICABLE} DWORD;
	END_VAR
END_FUNCTION_BLOCK

{REDUND_ERROR} {REDUND_UNREPLICABLE} FUNCTION_BLOCK PMC_ReadXbotForce (*read xbot force*) (*$GROUP=User,$CAT=User,$GROUPICON=User.png,$CATICON=User.png*)
	VAR_INPUT
		Enable : {REDUND_UNREPLICABLE} BOOL; (* enable function block*)
		XbotID : {REDUND_UNREPLICABLE} USINT; (* xbot ID# (>0)*)
	END_VAR
	VAR_OUTPUT
		Valid : {REDUND_UNREPLICABLE} BOOL; (* successfully read xbot force*)
		Fx : {REDUND_UNREPLICABLE} REAL; (* force in X in Newtons*)
		Fy : {REDUND_UNREPLICABLE} REAL; (* force in Y in Newtons*)
		Fz : {REDUND_UNREPLICABLE} REAL; (* force in Z in Newtons *)
		Tx : {REDUND_UNREPLICABLE} REAL; (* torque about X axis in Newton*Meters*)
		Ty : {REDUND_UNREPLICABLE} REAL; (* torque about Y axis in Newton*Meters*)
		Tz : {REDUND_UNREPLICABLE} REAL; (* torque about Z axis in Newton*Meters*)
	END_VAR
	VAR_IN_OUT
		PM_Controller : PMControllerType; (*Tracks state of the entire PMC system*)
	END_VAR
	VAR
		RegVal : {REDUND_UNREPLICABLE} UDINT;
		curXID : {REDUND_UNREPLICABLE} USINT;
	END_VAR
END_FUNCTION_BLOCK

{REDUND_ERROR} {REDUND_UNREPLICABLE} FUNCTION_BLOCK PMC_ReadXbotPos (*read xbot position*) (*$GROUP=User,$CAT=User,$GROUPICON=User.png,$CATICON=User.png*)
	VAR_INPUT
		Enable : {REDUND_UNREPLICABLE} BOOL; (* enable FUNCTION block *)
		XbotID : {REDUND_UNREPLICABLE} USINT; (* xbot ID# (>0) *)
	END_VAR
	VAR_OUTPUT
		Valid : {REDUND_UNREPLICABLE} BOOL; (* xbot position is up-TO-DATE, if FALSE the output position is the last known position *)
		PosX : {REDUND_UNREPLICABLE} REAL; (* xbot X position in meters *)
		PosY : {REDUND_UNREPLICABLE} REAL; (* xbot Y position in meters *)
		PosZ : {REDUND_UNREPLICABLE} REAL; (* xbot Z position in meters *)
		PosRx : {REDUND_UNREPLICABLE} REAL; (* xbot rotation about X axis in radians *)
		PosRy : {REDUND_UNREPLICABLE} REAL; (* xbot rotation about Y axis in radians *)
		PosRz : {REDUND_UNREPLICABLE} REAL; (* xbot rotation about Z axis in radians *)
	END_VAR
	VAR_IN_OUT
		PM_Controller : PMControllerType; (*Tracks state of the entire PMC system*)
	END_VAR
	VAR
		RegVal : {REDUND_UNREPLICABLE} UDINT;
		curXID : {REDUND_UNREPLICABLE} USINT;
	END_VAR
END_FUNCTION_BLOCK

{REDUND_ERROR} {REDUND_UNREPLICABLE} FUNCTION_BLOCK PMC_ReadXbotState (*read a xbot's state*) (*$GROUP=User,$CAT=User,$GROUPICON=User.png,$CATICON=User.png*)
	VAR_INPUT
		Enable : {REDUND_UNREPLICABLE} BOOL; (* enable FUNCTION block *)
		XbotID : {REDUND_UNREPLICABLE} USINT; (* xbot ID# (>0) *)
	END_VAR
	VAR_OUTPUT
		Valid : {REDUND_UNREPLICABLE} BOOL; (* successfully read xbot state *)
		State : {REDUND_UNREPLICABLE} USINT; (* 0 = undetected, 1 = discovering, 2 = landed, 3 = idle, 4 = disabled, 5 = in motion, 6 = waiting, 7 = stopping, 8 = obstacle, 9 = hold, 10 = stopped, 14 = error *)
	END_VAR
	VAR_IN_OUT
		PM_Controller : PMControllerType; (*Tracks state of the entire PMC system*)
	END_VAR
	VAR
		ByteOffset : {REDUND_UNREPLICABLE} USINT;
		BitOffset : {REDUND_UNREPLICABLE} USINT;
		uTemp : {REDUND_UNREPLICABLE} USINT;
	END_VAR
	VAR CONSTANT
		MaxXbots : USINT := 80;
	END_VAR
END_FUNCTION_BLOCK

{REDUND_ERROR} FUNCTION_BLOCK PMC_Reboot (*reboot Planar Motor System*) (*$GROUP=User,$CAT=User,$GROUPICON=User.png,$CATICON=User.png*)
	VAR_INPUT
		Execute : {REDUND_UNREPLICABLE} BOOL; (* Execution of the function block begins on a rising edge of this input.*)
	END_VAR
	VAR_OUTPUT
		Ack : {REDUND_UNREPLICABLE} BOOL; (* Command has been received by PMC, any returned values can be used *)
		Done : {REDUND_UNREPLICABLE} BOOL; (* The PMC has finished rebooting*)
		Busy : {REDUND_UNREPLICABLE} BOOL; (* Function block is active and must continue to be called.*)
		Aborted : {REDUND_UNREPLICABLE} BOOL; (* Command aborted by another command*)
		Error : {REDUND_UNREPLICABLE} BOOL; (* Error occurred during execution.*)
		ErrorID : {REDUND_UNREPLICABLE} UINT; (* Error number*)
	END_VAR
	VAR_IN_OUT
		PM_Controller : PMControllerType; (*Tracks state of the entire PMC system*)
	END_VAR
	VAR
		PMCFuncInfo : {REDUND_UNREPLICABLE} PMCFuncInfoType;
		timeout : {REDUND_UNREPLICABLE} UINT;
		cmdHB : {REDUND_UNREPLICABLE} INT;
		requestEventID : BOOL;
	END_VAR
	VAR CONSTANT
		cmdID : UINT := 2562;
	END_VAR
END_FUNCTION_BLOCK

{REDUND_ERROR} FUNCTION_BLOCK PMC_ResumeXbots (*unpause xbot motion*) (*$GROUP=User,$CAT=User,$GROUPICON=User.png,$CATICON=User.png*)
	VAR_INPUT
		Execute : {REDUND_UNREPLICABLE} BOOL; (* Execution of the function block begins on a rising edge of this input.*)
		XbotID : {REDUND_UNREPLICABLE} USINT; (* 0: all Xbots; >0: specific Xbot*)
	END_VAR
	VAR_OUTPUT
		Ack : {REDUND_UNREPLICABLE} BOOL; (* Command has been received by PMC, any returned values can be used*)
		Done : {REDUND_UNREPLICABLE} BOOL; (* Xbot(s) have resumed motion*)
		Busy : {REDUND_UNREPLICABLE} BOOL; (* Function block is active and must continue to be called.*)
		Aborted : {REDUND_UNREPLICABLE} BOOL; (* Command aborted by another command*)
		Error : {REDUND_UNREPLICABLE} BOOL; (* Error occurred during execution.*)
		ErrorID : {REDUND_UNREPLICABLE} UINT; (* Error number*)
	END_VAR
	VAR_IN_OUT
		PM_Controller : PMControllerType; (*Tracks state of the entire PMC system*)
	END_VAR
	VAR
		PMCFuncInfo : {REDUND_UNREPLICABLE} PMCFuncInfoType;
		timeout : {REDUND_UNREPLICABLE} UINT;
		cmdHB : {REDUND_UNREPLICABLE} INT;
		requestEventID : BOOL;
	END_VAR
	VAR CONSTANT
		cmdID : UINT := 2849;
		Level : USINT := 0;
	END_VAR
END_FUNCTION_BLOCK

{REDUND_ERROR} FUNCTION_BLOCK PMC_RunMacro (*command xbot to run a macro*) (*$GROUP=User,$CAT=User,$GROUPICON=User.png,$CATICON=User.png*)
	VAR_INPUT
		Execute : {REDUND_UNREPLICABLE} BOOL; (* Execution of the function block begins on a rising edge of this input.*)
		cmdLB : {REDUND_UNREPLICABLE} UINT; (* label to be associated with this command in the PMC*)
		MacroID : {REDUND_UNREPLICABLE} USINT; (* macro ID# (128 - 191)*)
		XbotID : {REDUND_UNREPLICABLE} USINT; (* xbot ID# (>0)*)
	END_VAR
	VAR_OUTPUT
		Ack : {REDUND_UNREPLICABLE} BOOL; (* Command has been received by PMC, any returned values can be used*)
		Done : {REDUND_UNREPLICABLE} BOOL; (* Xbots has finished the macro*)
		Busy : {REDUND_UNREPLICABLE} BOOL; (* Function block is active and must continue to be called.*)
		Aborted : {REDUND_UNREPLICABLE} BOOL; (* Command aborted by another command*)
		Error : {REDUND_UNREPLICABLE} BOOL; (* Error occurred during execution.*)
		ErrorID : {REDUND_UNREPLICABLE} UINT; (* Error number*)
	END_VAR
	VAR_IN_OUT
		PM_Controller : PMControllerType; (*Tracks state of the entire PMC system*)
	END_VAR
	VAR
		PMCFuncInfo : {REDUND_UNREPLICABLE} PMCFuncInfoType;
		timeout : {REDUND_UNREPLICABLE} UINT;
		cmdHB : {REDUND_UNREPLICABLE} INT;
		requestEventID : BOOL;
	END_VAR
	VAR CONSTANT
		cmdID : UINT := 2840;
	END_VAR
END_FUNCTION_BLOCK

{REDUND_ERROR} {REDUND_UNREPLICABLE} FUNCTION_BLOCK PMC_SaveMacro (*save macro*) (*$GROUP=User,$CAT=User,$GROUPICON=User.png,$CATICON=User.png*)
	VAR_INPUT
		Execute : {REDUND_UNREPLICABLE} BOOL; (* Execution of the function block begins on a rising edge of this input.*)
		MacroID : {REDUND_UNREPLICABLE} USINT; (* macro ID# (128 - 191)*)
	END_VAR
	VAR_OUTPUT
		Done : {REDUND_UNREPLICABLE} BOOL; (* Execution successful. Function block is finished*)
		Busy : {REDUND_UNREPLICABLE} BOOL; (* Function block is active and must continue to be called.*)
		Aborted : {REDUND_UNREPLICABLE} BOOL; (* Command aborted by another command*)
		Error : {REDUND_UNREPLICABLE} BOOL; (* Error occurred during execution.*)
		ErrorID : {REDUND_UNREPLICABLE} UINT; (* Error number*)
	END_VAR
	VAR_IN_OUT
		PM_Controller : PMControllerType; (*Tracks state of the entire PMC system*)
	END_VAR
	VAR
		PMCFuncInfo : {REDUND_UNREPLICABLE} PMCFuncInfoType;
		timeout : {REDUND_UNREPLICABLE} UINT;
		cmdHB : {REDUND_UNREPLICABLE} INT;
		DummyDone : {REDUND_UNREPLICABLE} BOOL;
	END_VAR
	VAR CONSTANT
		cmdID : UINT := 2839;
		Level : USINT := 2;
	END_VAR
END_FUNCTION_BLOCK

{REDUND_ERROR} {REDUND_UNREPLICABLE} FUNCTION_BLOCK PMC_SendDigitalSignalToPMC (*set/reset a digital input to the PMC*) (*$GROUP=User,$CAT=User,$GROUPICON=User.png,$CATICON=User.png*)
	VAR_INPUT
		Enable : {REDUND_UNREPLICABLE} BOOL; (* enable the function block*)
		DoID : {REDUND_UNREPLICABLE} USINT; (* digital output (of the PLC fieldbus) ID# [1-128]*)
		Level : {REDUND_UNREPLICABLE} BOOL; (* desired digital signal level*)
	END_VAR
	VAR_OUTPUT
		Valid : {REDUND_UNREPLICABLE} BOOL; (* successfully set/reset the digital signal*)
	END_VAR
	VAR_IN_OUT
		PM_Controller : PMControllerType; (*Tracks state of the entire PMC system*)
	END_VAR
	VAR
		ByteOffset : {REDUND_UNREPLICABLE} DINT;
		BitOffset : {REDUND_UNREPLICABLE} DINT;
		step1 : {REDUND_UNREPLICABLE} USINT;
		step2 : {REDUND_UNREPLICABLE} USINT;
		step3 : {REDUND_UNREPLICABLE} USINT;
		RegVal : {REDUND_UNREPLICABLE} USINT;
	END_VAR
END_FUNCTION_BLOCK

{REDUND_ERROR} {REDUND_UNREPLICABLE} FUNCTION_BLOCK PMC_SetConfiguration (*Sends a configuration file (as raw binary) to the PMC*) (*$GROUP=User,$CAT=User,$GROUPICON=User.png,$CATICON=User.png*)
	VAR_INPUT
		Execute : {REDUND_UNREPLICABLE} BOOL; (* Execution of the function block begins on a rising edge of this input.*)
		nBytes : {REDUND_UNREPLICABLE} UDINT; (* number of bytes in the configuration file (up to 500,000 bytes)*)
		Bytes : {REDUND_UNREPLICABLE} ARRAY[0..500000] OF USINT; (* the configuration file as a raw binary*)
	END_VAR
	VAR_OUTPUT
		Done : {REDUND_UNREPLICABLE} BOOL; (* Execution successful. Function block is finished*)
		Busy : {REDUND_UNREPLICABLE} BOOL; (* Function block is active and must continue to be called.*)
		Aborted : {REDUND_UNREPLICABLE} BOOL; (* Command aborted by another command*)
		Error : {REDUND_UNREPLICABLE} BOOL; (* Error occurred during execution.*)
		ErrorID : {REDUND_UNREPLICABLE} UINT; (* Error number*)
	END_VAR
	VAR_IN_OUT
		PM_Controller : PMControllerType; (*Tracks state of the entire PMC system*)
	END_VAR
	VAR
		PMCFuncInfo : {REDUND_UNREPLICABLE} PMCFuncInfoType;
		timeout : {REDUND_UNREPLICABLE} UINT;
		numFrames : {REDUND_UNREPLICABLE} DINT;
		cmdHB : {REDUND_UNREPLICABLE} INT;
		totalByteNum : {REDUND_UNREPLICABLE} DINT;
		xIndex : {REDUND_UNREPLICABLE} DINT;
		beginning_index : {REDUND_UNREPLICABLE} DINT;
		numBytesToSend : {REDUND_UNREPLICABLE} SINT;
		DummyDone : {REDUND_UNREPLICABLE} BOOL;
	END_VAR
	VAR CONSTANT
		cmdID : UINT := 65292;
		maxNByte : DINT := 500000;
		maxNBytePerFrame : SINT := 90;
	END_VAR
END_FUNCTION_BLOCK

{REDUND_ERROR} {REDUND_UNREPLICABLE} FUNCTION_BLOCK PMC_SetXbotProperty (*set a xbot property*) (*$GROUP=User,$CAT=User,$GROUPICON=User.png,$CATICON=User.png*)
	VAR_INPUT
		Execute : {REDUND_UNREPLICABLE} BOOL; (* Execution of the function block begins on a rising edge of this input.*)
		nXbots : {REDUND_UNREPLICABLE} USINT; (* number of xbots to set a property on (up to 14)*)
		XbotID : {REDUND_UNREPLICABLE} ARRAY[0..13] OF USINT; (* array of xbot ID#*)
		PropertyID : {REDUND_UNREPLICABLE} ARRAY[0..13] OF USINT; (* array of property IDs; 0: mover type (read only); 1: user configured payload; 2: user configured center of gravity in Z; 3: payload X dimension; 5: payload Y dimension; 7: acceleration limit (read only)   *)
		Value : {REDUND_UNREPLICABLE} ARRAY[0..13] OF REAL; (* array of property values; 1: user configured payload (kilograms); 2: user configured center of gravity in Z (meters); 3: payload X dimension (meters); 5: payload Y dimension (meters)*)
	END_VAR
	VAR_OUTPUT
		Done : {REDUND_UNREPLICABLE} BOOL; (* Execution successful. Function block is finished*)
		Busy : {REDUND_UNREPLICABLE} BOOL; (* Function block is active and must continue to be called.*)
		Aborted : {REDUND_UNREPLICABLE} BOOL; (* Command aborted by another command*)
		Error : {REDUND_UNREPLICABLE} BOOL; (* Error occurred during execution.*)
		ErrorID : {REDUND_UNREPLICABLE} UINT; (* Error number*)
	END_VAR
	VAR_IN_OUT
		PM_Controller : PMControllerType; (*Tracks state of the entire PMC system*)
	END_VAR
	VAR
		PMCFuncInfo : {REDUND_UNREPLICABLE} PMCFuncInfoType;
		timeout : {REDUND_UNREPLICABLE} UINT;
		cmdHB : {REDUND_UNREPLICABLE} INT;
		xbotNum : {REDUND_UNREPLICABLE} USINT;
		xIndex : {REDUND_UNREPLICABLE} SINT;
		DummyDone : {REDUND_UNREPLICABLE} BOOL;
	END_VAR
	VAR CONSTANT
		cmdID : UINT := 2845;
		maxNXbots : SINT := 14;
	END_VAR
END_FUNCTION_BLOCK

{REDUND_ERROR} FUNCTION_BLOCK PMC_ShortAxisMotion (*move xbot in Z, Rx, Ry, and, Rz*) (*$GROUP=User,$CAT=User,$GROUPICON=User.png,$CATICON=User.png*)
	VAR_INPUT
		Execute : {REDUND_UNREPLICABLE} BOOL := FALSE; (* Execution of the function block begins on a rising edge of this input*)
		cmdLB : {REDUND_UNREPLICABLE} UINT := 0; (* label to be associated with this command in the PMC*)
		XbotID : {REDUND_UNREPLICABLE} USINT := 0; (* ID# of the xbot to move (>0)*)
		Mode : {REDUND_UNREPLICABLE} USINT := 0; (* 0:Absolute;1:Relative*)
		Type_ : {REDUND_UNREPLICABLE} USINT := 0; (* 0: Rotation only;1: Planar Rotation*)
		PosZ : {REDUND_UNREPLICABLE} REAL := 0.001; (* Z position in meters*)
		PosRx : {REDUND_UNREPLICABLE} REAL := 0.0; (* rotation about X axis in radians*)
		PosRy : {REDUND_UNREPLICABLE} REAL := 0.0; (* rotation about Y axis in radians*)
		PosRz : {REDUND_UNREPLICABLE} REAL := 0.0; (* rotation about Z axis in radians*)
		VelZ : {REDUND_UNREPLICABLE} REAL := 0.1; (* velocity in Z axis in meters/second*)
		VelRx : {REDUND_UNREPLICABLE} REAL := 0.1; (* velocity of X axis rotation in radians/second*)
		VelRy : {REDUND_UNREPLICABLE} REAL := 0.1; (* velocity of Y axis rotation in radians/second*)
		VelRz : {REDUND_UNREPLICABLE} REAL := 0.5; (* velocity of Z axis rotation in radians/second*)
		Cx : {REDUND_UNREPLICABLE} REAL := 0.0; (* Rotation center in X when type=1*)
		Cy : {REDUND_UNREPLICABLE} REAL := 0.0; (* Rotation center in Y when type=1*)
	END_VAR
	VAR_OUTPUT
		Ack : {REDUND_UNREPLICABLE} BOOL; (* Command has been received by PMC, any returned values can be used*)
		Done : {REDUND_UNREPLICABLE} BOOL; (* Xbot's motion has completed*)
		Busy : {REDUND_UNREPLICABLE} BOOL; (* Function block is active and must continue to be called.*)
		Aborted : {REDUND_UNREPLICABLE} BOOL; (* Command aborted by another command*)
		Error : {REDUND_UNREPLICABLE} BOOL; (* Error occurred during execution.*)
		ErrorID : {REDUND_UNREPLICABLE} UINT; (* Error number*)
		TravelTime : {REDUND_UNREPLICABLE} REAL; (* Time needed for the motion to complete in seconds *)
	END_VAR
	VAR_IN_OUT
		PM_Controller : PMControllerType; (*Tracks state of the entire PMC system*)
	END_VAR
	VAR
		PMCFuncInfo : {REDUND_UNREPLICABLE} PMCFuncInfoType;
		timeout : {REDUND_UNREPLICABLE} UINT;
		cmdHB : {REDUND_UNREPLICABLE} INT;
		nTemp : {REDUND_UNREPLICABLE} DWORD;
		requestEventID : BOOL;
	END_VAR
	VAR CONSTANT
		cmdID : UINT := 2825;
	END_VAR
END_FUNCTION_BLOCK

{REDUND_ERROR} {REDUND_UNREPLICABLE} FUNCTION_BLOCK PMC_StartUpPlanarMotorSystem (*activate PMC, levitate all xbots, report number of xbots in system and their ID#s*) (*$GROUP=User,$CAT=User,$GROUPICON=User.png,$CATICON=User.png*)
	VAR_INPUT
		Execute : {REDUND_UNREPLICABLE} BOOL; (* Execution of the function block begins on a rising edge of this input*)
		timeout_limit : {REDUND_UNREPLICABLE} DINT; (* timeout limit for this command in number of calls*)
	END_VAR
	VAR_OUTPUT
		Done : {REDUND_UNREPLICABLE} BOOL; (* Execution successful. Function block is finished*)
		Busy : {REDUND_UNREPLICABLE} BOOL; (* Function block is active and must continue to be called.*)
		Aborted : {REDUND_UNREPLICABLE} BOOL; (* Command aborted by another command*)
		Error : {REDUND_UNREPLICABLE} BOOL; (* Error occurred during execution.*)
		ErrorID : {REDUND_UNREPLICABLE} UINT; (* Error number*)
		NumXbots : {REDUND_UNREPLICABLE} USINT; (* number of xbots in system*)
		Xbot_IDs : {REDUND_UNREPLICABLE} ARRAY[0..77] OF USINT; (* xbot ID#s of xbots in the system*)
	END_VAR
	VAR_IN_OUT
		PM_Controller : PMControllerType; (*Tracks state of the entire PMC system*)
	END_VAR
	VAR
		aborted_local : {REDUND_UNREPLICABLE} BOOL;
		busy_local : {REDUND_UNREPLICABLE} BOOL;
		CmdSta : {REDUND_UNREPLICABLE} INT;
		done_local : {REDUND_UNREPLICABLE} BOOL;
		error_local : {REDUND_UNREPLICABLE} BOOL;
		errorID_local : {REDUND_UNREPLICABLE} UINT;
		execute_local : {REDUND_UNREPLICABLE} BOOL;
		ideal_loop_counter : {REDUND_UNREPLICABLE} DINT;
		PMC_ActivateXbots_db : {REDUND_UNREPLICABLE} PMC_ActivateXbots;
		PMC_LevitationCtrl_db : {REDUND_UNREPLICABLE} PMC_LevitationCtrl;
		PMC_ReadXbotState_db : {REDUND_UNREPLICABLE} PMC_ReadXbotState;
		PMC_ReadPmcState_db : {REDUND_UNREPLICABLE} PMC_ReadPmcState;
		pmc_state : {REDUND_UNREPLICABLE} USINT;
		PreExecute_local : {REDUND_UNREPLICABLE} BOOL;
		prestep : {REDUND_UNREPLICABLE} DINT;
		step : {REDUND_UNREPLICABLE} DINT;
		timeout_counter : {REDUND_UNREPLICABLE} DINT;
		xbot_array_index : {REDUND_UNREPLICABLE} DINT;
		xbot_loop_index : {REDUND_UNREPLICABLE} DINT;
		xbot_state : {REDUND_UNREPLICABLE} USINT;
		resetFBs : {REDUND_UNREPLICABLE} BOOL;
	END_VAR
END_FUNCTION_BLOCK

{REDUND_ERROR} FUNCTION_BLOCK PMC_StopXbots (*stop motion of xbot and clear its buffer*) (*$GROUP=User,$CAT=User,$GROUPICON=User.png,$CATICON=User.png*)
	VAR_INPUT
		Execute : {REDUND_UNREPLICABLE} BOOL; (* Execution of the function block begins on a rising edge of this input.*)
		XbotID : {REDUND_UNREPLICABLE} USINT; (* xbot ID#; 0: all xbots; 1: specific xbot*)
	END_VAR
	VAR_OUTPUT
		Ack : {REDUND_UNREPLICABLE} BOOL; (* Command has been received by PMC, any returned values can be used*)
		Done : {REDUND_UNREPLICABLE} BOOL; (* Xbots have stopped moving*)
		Busy : {REDUND_UNREPLICABLE} BOOL; (* Function block is active and must continue to be called.*)
		Aborted : {REDUND_UNREPLICABLE} BOOL; (* Command aborted by another command*)
		Error : {REDUND_UNREPLICABLE} BOOL; (* Error occurred during execution.*)
		ErrorID : {REDUND_UNREPLICABLE} UINT; (* Error number*)
	END_VAR
	VAR_IN_OUT
		PM_Controller : PMControllerType; (*Tracks state of the entire PMC system*)
	END_VAR
	VAR
		PMCFuncInfo : {REDUND_UNREPLICABLE} PMCFuncInfoType;
		timeout : {REDUND_UNREPLICABLE} UINT;
		cmdHB : {REDUND_UNREPLICABLE} INT;
		requestEventID : BOOL;
	END_VAR
	VAR CONSTANT
		cmdID : UINT := 2827;
	END_VAR
END_FUNCTION_BLOCK

{REDUND_ERROR} {REDUND_UNREPLICABLE} FUNCTION_BLOCK PMC_StreamModeCtrl (*configure xbot reference streaming*) (*$GROUP=User,$CAT=User,$GROUPICON=User.png,$CATICON=User.png*)
	VAR_INPUT
		Execute : {REDUND_UNREPLICABLE} BOOL; (* Execution of the function block begins on a rising edge of this input.*)
		Level : {REDUND_UNREPLICABLE} USINT; (* 0:Exit from stream mode;1: Enter stream mode*)
		nXbots : {REDUND_UNREPLICABLE} USINT; (* number of xbots to configure streaming for (up to 9)*)
		XbotID : {REDUND_UNREPLICABLE} ARRAY[0..8] OF USINT; (* array of xbot ID#s*)
		StmID : {REDUND_UNREPLICABLE} ARRAY[0..8] OF USINT; (* stream ID#s*)
		StmAxis : {REDUND_UNREPLICABLE} ARRAY[0..8] OF USINT; (* Bit0: X;Bit1:Y;Bit2:Z;Bit3: Rx; Bit4: Ry; Bit5: Rz*)
		offsetX : {REDUND_UNREPLICABLE} ARRAY[0..8] OF REAL; (* offset in X for stream position (meters)*)
		offsetY : {REDUND_UNREPLICABLE} ARRAY[0..8] OF REAL; (* offset in Y for stream position (meters)*)
	END_VAR
	VAR_OUTPUT
		Done : {REDUND_UNREPLICABLE} BOOL; (* Execution successful. Function block is finished*)
		Busy : {REDUND_UNREPLICABLE} BOOL; (* Function block is active and must continue to be called.*)
		Aborted : {REDUND_UNREPLICABLE} BOOL; (* Command aborted by another command*)
		Error : {REDUND_UNREPLICABLE} BOOL; (* Error occurred during execution.*)
		ErrorID : {REDUND_UNREPLICABLE} UINT; (* Error number*)
	END_VAR
	VAR_IN_OUT
		PM_Controller : PMControllerType; (*Tracks state of the entire PMC system*)
	END_VAR
	VAR
		PMCFuncInfo : {REDUND_UNREPLICABLE} PMCFuncInfoType;
		timeout : {REDUND_UNREPLICABLE} UINT;
		numFrames : {REDUND_UNREPLICABLE} DINT;
		cmdHB : {REDUND_UNREPLICABLE} INT;
		xbotNum : {REDUND_UNREPLICABLE} USINT;
		xIndex : {REDUND_UNREPLICABLE} SINT;
		DummyDone : {REDUND_UNREPLICABLE} BOOL;
		totalXbotNum : {REDUND_UNREPLICABLE} SINT;
		beginning_index : {REDUND_UNREPLICABLE} SINT;
		numXbotsToSend : {REDUND_UNREPLICABLE} SINT;
	END_VAR
	VAR CONSTANT
		cmdID : UINT := 2830;
		maxNXbotPerFrame : SINT := 8;
		maxNXbot : SINT := 9;
	END_VAR
END_FUNCTION_BLOCK

{REDUND_ERROR} FUNCTION_BLOCK PMC_SyncMotion (*send linear motion commands to multiple xbots at once*) (*$GROUP=User,$CAT=User,$GROUPICON=User.png,$CATICON=User.png*)
	VAR_INPUT
		Execute : {REDUND_UNREPLICABLE} BOOL; (* Execution of the function block begins on a rising edge of this input.*)
		nXbots : {REDUND_UNREPLICABLE} USINT; (* number of xbots to send linear move to (up to 4)*)
		XbotID : {REDUND_UNREPLICABLE} ARRAY[0..3] OF USINT; (* xbot ID#s*)
		PosX : {REDUND_UNREPLICABLE} ARRAY[0..3] OF REAL; (* X positions in meters*)
		PosY : {REDUND_UNREPLICABLE} ARRAY[0..3] OF REAL; (* Y positions in meters*)
		EndVel : {REDUND_UNREPLICABLE} ARRAY[0..3] OF REAL; (* Ending velocities in meters/second*)
		MaxVel : {REDUND_UNREPLICABLE} ARRAY[0..3] OF REAL; (* maximum velocities in meters/second*)
		MaxAcc : {REDUND_UNREPLICABLE} ARRAY[0..3] OF REAL; (* maximum accelerations in meters/second^2*)
	END_VAR
	VAR_OUTPUT
		Ack : {REDUND_UNREPLICABLE} BOOL; (* Command has been received by PMC, any returned values can be used*)
		Done : {REDUND_UNREPLICABLE} BOOL; (* Xbot(s) motion has completed*)
		Busy : {REDUND_UNREPLICABLE} BOOL; (* Function block is active and must continue to be called.*)
		Aborted : {REDUND_UNREPLICABLE} BOOL; (* Command aborted by another command*)
		Error : {REDUND_UNREPLICABLE} BOOL; (* Error occurred during execution.*)
		ErrorID : {REDUND_UNREPLICABLE} UINT; (* Error number*)
		TravelTime : {REDUND_UNREPLICABLE} REAL; (* Time needed for the motion to complete in seconds*)
	END_VAR
	VAR_IN_OUT
		PM_Controller : PMControllerType; (*Tracks state of the entire PMC system*)
	END_VAR
	VAR
		PMCFuncInfo : {REDUND_UNREPLICABLE} PMCFuncInfoType;
		timeout : {REDUND_UNREPLICABLE} UINT;
		cmdHB : {REDUND_UNREPLICABLE} INT;
		xbotNum : {REDUND_UNREPLICABLE} USINT;
		xIndex : {REDUND_UNREPLICABLE} SINT;
		nTemp : {REDUND_UNREPLICABLE} DWORD;
		requestEventID : BOOL;
	END_VAR
	VAR CONSTANT
		cmdID : UINT := 2835;
		maxNXbot : SINT := 4;
	END_VAR
END_FUNCTION_BLOCK

{REDUND_ERROR} FUNCTION_BLOCK PMC_WaitUntilCmdLb (*xbot waits until another xbot performs a command label*) (*$GROUP=User,$CAT=User,$GROUPICON=User.png,$CATICON=User.png*)
	VAR_INPUT
		Execute : {REDUND_UNREPLICABLE} BOOL; (* Execution of the function block begins on a rising edge of this input.*)
		cmdLB : {REDUND_UNREPLICABLE} UINT; (* label to be associated with this command in the PMC*)
		XbotID : {REDUND_UNREPLICABLE} USINT; (* ID# of the xbot to wait (>0)*)
		TriggerXID : {REDUND_UNREPLICABLE} USINT; (* Trigger Xbot ID*)
		TriggerType : {REDUND_UNREPLICABLE} USINT; (* 0: Begin;1: End; 2: Execute*)
		TriggerCmdLb : {REDUND_UNREPLICABLE} UINT; (* command label to wait for*)
		LabelType : {REDUND_UNREPLICABLE} USINT; (* 0: Motion Cmd Label;1: Run Macro Cmd Label*)
	END_VAR
	VAR_OUTPUT
		Ack : {REDUND_UNREPLICABLE} BOOL; (* Command has been received by PMC, any returned values can be used*)
		Done : {REDUND_UNREPLICABLE} BOOL; (* Xbot has stopped waiting*)
		Busy : {REDUND_UNREPLICABLE} BOOL; (* Function block is active and must continue to be called.*)
		Aborted : {REDUND_UNREPLICABLE} BOOL; (* Command aborted by another command*)
		Error : {REDUND_UNREPLICABLE} BOOL; (* Error occurred during execution.*)
		ErrorID : {REDUND_UNREPLICABLE} UINT; (* Error number*)
	END_VAR
	VAR_IN_OUT
		PM_Controller : PMControllerType; (*Tracks state of the entire PMC system*)
	END_VAR
	VAR
		PMCFuncInfo : {REDUND_UNREPLICABLE} PMCFuncInfoType;
		timeout : {REDUND_UNREPLICABLE} UINT;
		cmdHB : {REDUND_UNREPLICABLE} INT;
		requestEventID : BOOL;
	END_VAR
	VAR CONSTANT
		cmdID : UINT := 2841;
		type_ : USINT := 3;
		count : USINT := 1;
		option : USINT := 0;
	END_VAR
END_FUNCTION_BLOCK

{REDUND_ERROR} FUNCTION_BLOCK PMC_WaitUntilDisp (*xbot waits until another xbots reaches a given displacement*) (*$GROUP=User,$CAT=User,$GROUPICON=User.png,$CATICON=User.png*)
	VAR_INPUT
		Execute : {REDUND_UNREPLICABLE} BOOL; (* Execution of the function block begins on a rising edge of this input.*)
		cmdLB : {REDUND_UNREPLICABLE} UINT; (* label to be associated with this command in the PMC*)
		XbotID : {REDUND_UNREPLICABLE} USINT; (* ID# of the xbot to wait (>0)*)
		TriggerXID : {REDUND_UNREPLICABLE} USINT; (* Trigger Xbot ID*)
		dispMode : {REDUND_UNREPLICABLE} USINT; (* 0: X only; 1: Y only; 2: posXFactor*X + posYFactor*Y*)
		dispType : {REDUND_UNREPLICABLE} USINT; (* 0: Greater Than;1: Less Than; 2: Positive cross;3: Negative cross*)
		Threshold : {REDUND_UNREPLICABLE} REAL; (* threshold to wait until in meters*)
		posXFactor : {REDUND_UNREPLICABLE} REAL; (* XFactor used for dispMode 2*)
		posYFactor : {REDUND_UNREPLICABLE} REAL; (* YFactor used for dispMode 2*)
	END_VAR
	VAR_OUTPUT
		Ack : {REDUND_UNREPLICABLE} BOOL; (* Command has been received by PMC, any returned values can be used*)
		Done : {REDUND_UNREPLICABLE} BOOL; (* Xbot has stopped waiting*)
		Busy : {REDUND_UNREPLICABLE} BOOL; (* Function block is active and must continue to be called.*)
		Aborted : {REDUND_UNREPLICABLE} BOOL; (* Command aborted by another command*)
		Error : {REDUND_UNREPLICABLE} BOOL; (* Error occurred during execution.*)
		ErrorID : {REDUND_UNREPLICABLE} UINT; (* Error number*)
	END_VAR
	VAR_IN_OUT
		PM_Controller : PMControllerType; (*Tracks state of the entire PMC system*)
	END_VAR
	VAR
		PMCFuncInfo : {REDUND_UNREPLICABLE} PMCFuncInfoType;
		timeout : {REDUND_UNREPLICABLE} UINT;
		cmdHB : {REDUND_UNREPLICABLE} INT;
	END_VAR
	VAR CONSTANT
		cmdID : UINT := 2841;
		type_ : USINT := 4;
		count : USINT := 1;
	END_VAR
	VAR
		requestEventID : BOOL;
	END_VAR
	VAR CONSTANT
		option : USINT := 0;
	END_VAR
END_FUNCTION_BLOCK

{REDUND_ERROR} FUNCTION_BLOCK PMC_WaitUntilFBDI (*xbot waits for a PMC digital input *) (*$GROUP=User,$CAT=User,$GROUPICON=User.png,$CATICON=User.png*)
	VAR_INPUT
		Execute : {REDUND_UNREPLICABLE} BOOL; (* Execution of the function block begins on a rising edge of this input.*)
		cmdLB : {REDUND_UNREPLICABLE} UINT; (* label to be associated with this command in the PMC*)
		XbotID : {REDUND_UNREPLICABLE} USINT; (* ID# of the xbot to wait (>0)*)
		TriggerDI : {REDUND_UNREPLICABLE} USINT; (* Trigger Digital ID*)
		TriggerType : {REDUND_UNREPLICABLE} USINT; (* 0: Rising Edge;1: Falling Edge; 2: High Level;3: Low Level*)
	END_VAR
	VAR_OUTPUT
		Ack : {REDUND_UNREPLICABLE} BOOL; (* Command has been received by PMC, any returned values can be used*)
		Done : {REDUND_UNREPLICABLE} BOOL; (* Xbot has stopped waiting*)
		Busy : {REDUND_UNREPLICABLE} BOOL; (* Function block is active and must continue to be called.*)
		Aborted : {REDUND_UNREPLICABLE} BOOL; (* Command aborted by another command*)
		Error : {REDUND_UNREPLICABLE} BOOL; (* Error occurred during execution.*)
		ErrorID : {REDUND_UNREPLICABLE} UINT; (* Error number*)
	END_VAR
	VAR_IN_OUT
		PM_Controller : PMControllerType; (*Tracks state of the entire PMC system*)
	END_VAR
	VAR
		PMCFuncInfo : {REDUND_UNREPLICABLE} PMCFuncInfoType;
		timeout : {REDUND_UNREPLICABLE} UINT;
		cmdHB : {REDUND_UNREPLICABLE} INT;
	END_VAR
	VAR CONSTANT
		cmdID : UINT := 2841;
		type_ : USINT := 2;
		count : USINT := 1;
	END_VAR
	VAR
		requestEventID : BOOL;
	END_VAR
	VAR CONSTANT
		option : USINT := 0;
	END_VAR
END_FUNCTION_BLOCK

{REDUND_ERROR} FUNCTION_BLOCK PMC_WaitUntilTimeDelay (*xbot waits for a amount of time*) (*$GROUP=User,$CAT=User,$GROUPICON=User.png,$CATICON=User.png*)
	VAR_INPUT
		Execute : {REDUND_UNREPLICABLE} BOOL; (* Execution of the function block begins on a rising edge of this input.*)
		cmdLB : {REDUND_UNREPLICABLE} UINT; (* label to be associated with this command in the PMC*)
		XbotID : {REDUND_UNREPLICABLE} USINT; (* ID# of the xbot to wait (>0)*)
		Delay : {REDUND_UNREPLICABLE} REAL; (* time to wait for in seconds*)
	END_VAR
	VAR_OUTPUT
		Ack : {REDUND_UNREPLICABLE} BOOL; (* Command has been received by PMC, any returned values can be used*)
		Done : {REDUND_UNREPLICABLE} BOOL; (* Xbot has stopped waiting*)
		Busy : {REDUND_UNREPLICABLE} BOOL; (* Function block is active and must continue to be called.*)
		Aborted : {REDUND_UNREPLICABLE} BOOL; (* Command aborted by another command*)
		Error : {REDUND_UNREPLICABLE} BOOL; (* Error occurred during execution.*)
		ErrorID : {REDUND_UNREPLICABLE} UINT; (* Error number*)
	END_VAR
	VAR_IN_OUT
		PM_Controller : PMControllerType; (*Tracks state of the entire PMC system*)
	END_VAR
	VAR
		PMCFuncInfo : {REDUND_UNREPLICABLE} PMCFuncInfoType;
		timeout : {REDUND_UNREPLICABLE} UINT;
		cmdHB : {REDUND_UNREPLICABLE} INT;
	END_VAR
	VAR CONSTANT
		cmdID : UINT := 2841;
		type_ : USINT := 0;
		count : USINT := 1;
	END_VAR
	VAR
		requestEventID : BOOL;
	END_VAR
	VAR CONSTANT
		option : USINT := 0;
	END_VAR
END_FUNCTION_BLOCK

{REDUND_ERROR} {REDUND_UNREPLICABLE} FUNCTION_BLOCK PMC_WriteStream (*Write a reference position/force to the PMC*) (*$GROUP=User,$CAT=User,$GROUPICON=User.png,$CATICON=User.png*)
	VAR_INPUT
		Enable : {REDUND_UNREPLICABLE} BOOL; (* enable function block*)
		StmID : {REDUND_UNREPLICABLE} USINT; (* stream ID#s [1-9]*)
		AxisID : {REDUND_UNREPLICABLE} USINT; (* 1: X; 2: Y; 3: Z; 4: Rx; 5: Ry; 6: Rz*)
		Pos : {REDUND_UNREPLICABLE} REAL; (* reference value; meters for position X/Y/Z; radians for position Rx/Ry/Rz; Newtons for force X/Y/Z; Newton*Meters for force Rx,Ry,Rz*)
	END_VAR
	VAR_OUTPUT
		Valid : {REDUND_UNREPLICABLE} BOOL; (* successfully wrote reference stream*)
	END_VAR
	VAR_IN_OUT
		PM_Controller : PMControllerType; (*Tracks state of the entire PMC system*)
	END_VAR
	VAR
		ByteOffset : {REDUND_UNREPLICABLE} UDINT;
	END_VAR
END_FUNCTION_BLOCK

{REDUND_ERROR} FUNCTION_BLOCK PMC_XYMotion (*xbot moves in X and Y axes*) (*$GROUP=User,$CAT=User,$GROUPICON=User.png,$CATICON=User.png*)
	VAR_INPUT
		Execute : {REDUND_UNREPLICABLE} BOOL; (* Execution of the function block begins on a rising edge of this input.*)
		cmdLB : {REDUND_UNREPLICABLE} UINT; (* label to be associated with this command in the PMC*)
		XbotID : {REDUND_UNREPLICABLE} USINT; (* ID# of the xbot to move (>0)*)
		Mode : {REDUND_UNREPLICABLE} USINT; (* 0: Absolute position. 1: relative positioning*)
		Type_ : {REDUND_UNREPLICABLE} USINT; (* 0: direct straight line; 1: move in X then Y; 2: move in Y then X*)
		PosX : {REDUND_UNREPLICABLE} REAL; (* X position in meters*)
		PosY : {REDUND_UNREPLICABLE} REAL; (* Y position in meters*)
		EndVel : {REDUND_UNREPLICABLE} REAL; (* ending velocity in meters/second*)
		MaxVel : {REDUND_UNREPLICABLE} REAL := 1.0; (* maximum velocity in meters/second*)
		MaxAcc : {REDUND_UNREPLICABLE} REAL := 10.0; (* maximum acceleration in meters/second^2*)
	END_VAR
	VAR_OUTPUT
		Ack : {REDUND_UNREPLICABLE} BOOL; (* Command has been received by PMC, any returned values can be used *)
		Done : {REDUND_UNREPLICABLE} BOOL; (* Xbot's motion has completed*)
		Busy : {REDUND_UNREPLICABLE} BOOL; (* Function block is active and must continue to be called.*)
		Aborted : {REDUND_UNREPLICABLE} BOOL; (* Command aborted by another command*)
		Error : {REDUND_UNREPLICABLE} BOOL; (* Error occurred during execution.*)
		ErrorID : {REDUND_UNREPLICABLE} UINT; (* Error number*)
		TravelTime : {REDUND_UNREPLICABLE} REAL; (* Time needed for the motion to complete in seconds*)
	END_VAR
	VAR_IN_OUT
		PM_Controller : PMControllerType; (*Tracks state of the entire PMC system*)
	END_VAR
	VAR
		PMCFuncInfo : {REDUND_UNREPLICABLE} PMCFuncInfoType;
		timeout : {REDUND_UNREPLICABLE} UINT;
		cmdHB : {REDUND_UNREPLICABLE} INT;
		nTemp : {REDUND_UNREPLICABLE} DWORD;
		requestEventID : BOOL;
	END_VAR
	VAR CONSTANT
		cmdID : UINT := 2824;
	END_VAR
END_FUNCTION_BLOCK
